/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.crl.CRLUtils;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.pdf.PdfArray;
import eu.europa.esig.dss.pdf.PdfDict;
import eu.europa.esig.dss.spi.DSSUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSSDictionaryExtractionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DSSDictionaryExtractionUtils.class);

    public static Map<Long, CertificateToken> getCertsFromArray(PdfDict dict, String dictionaryName, String arrayName) {
        LinkedHashMap<Long, CertificateToken> certMap = new LinkedHashMap<Long, CertificateToken>();
        PdfArray certsArray = dict.getAsArray(arrayName);
        if (certsArray != null) {
            LOG.debug("There are {} certificates in the '{}' dictionary", (Object)certsArray.size(), (Object)dictionaryName);
            for (int ii = 0; ii < certsArray.size(); ++ii) {
                try {
                    long objectNumber = certsArray.getObjectNumber(ii);
                    if (certMap.containsKey(objectNumber)) continue;
                    certMap.put(objectNumber, DSSUtils.loadCertificate((byte[])certsArray.getBytes(ii)));
                    continue;
                }
                catch (Exception e) {
                    LOG.debug("Unable to read Cert '{}' from the '{}' dictionary : {}", new Object[]{ii, dictionaryName, e.getMessage(), e});
                }
            }
        } else {
            LOG.debug("No Certs found in the '{}' dictionary", (Object)dictionaryName);
        }
        return certMap;
    }

    public static Map<Long, CRLBinary> getCRLsFromArray(PdfDict dict, String dictionaryName, String arrayName) {
        LinkedHashMap<Long, CRLBinary> crlMap = new LinkedHashMap<Long, CRLBinary>();
        PdfArray crlArray = dict.getAsArray(arrayName);
        if (crlArray != null) {
            LOG.debug("There are {} CRLs in the '{}' dictionary", (Object)crlArray.size(), (Object)dictionaryName);
            for (int ii = 0; ii < crlArray.size(); ++ii) {
                try {
                    long objectNumber = crlArray.getObjectNumber(ii);
                    if (crlMap.containsKey(objectNumber)) continue;
                    crlMap.put(objectNumber, CRLUtils.buildCRLBinary((byte[])crlArray.getBytes(ii)));
                    continue;
                }
                catch (Exception e) {
                    LOG.debug("Unable to read CRL '{}' from the '{}' dictionary : {}", new Object[]{ii, dictionaryName, e.getMessage(), e});
                }
            }
        } else {
            LOG.debug("No CRLs found in the '{}' dictionary", (Object)dictionaryName);
        }
        return crlMap;
    }

    public static Map<Long, BasicOCSPResp> getOCSPsFromArray(PdfDict dict, String dictionaryName, String arrayName) {
        LinkedHashMap<Long, BasicOCSPResp> ocspMap = new LinkedHashMap<Long, BasicOCSPResp>();
        PdfArray ocspArray = dict.getAsArray(arrayName);
        if (ocspArray != null) {
            LOG.debug("There are {} OCSPs in the '{}' dictionary", (Object)ocspArray.size(), (Object)dictionaryName);
            for (int ii = 0; ii < ocspArray.size(); ++ii) {
                try {
                    long objectNumber = ocspArray.getObjectNumber(ii);
                    if (ocspMap.containsKey(objectNumber)) continue;
                    OCSPResp ocspResp = new OCSPResp(ocspArray.getBytes(ii));
                    BasicOCSPResp responseObject = (BasicOCSPResp)ocspResp.getResponseObject();
                    ocspMap.put(objectNumber, responseObject);
                    continue;
                }
                catch (Exception e) {
                    LOG.debug("Unable to read OCSP '{}' from the '{}' dictionary : {}", new Object[]{ii, dictionaryName, e.getMessage(), e});
                }
            }
        } else {
            LOG.debug("No OCSPs found in the '{}' dictionary", (Object)dictionaryName);
        }
        return ocspMap;
    }
}

