/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf;

import eu.europa.esig.dss.pades.validation.PdfModification;
import eu.europa.esig.dss.pdf.AnnotationBox;
import eu.europa.esig.dss.pdf.PdfAnnotation;
import eu.europa.esig.dss.pdf.PdfDocumentReader;
import eu.europa.esig.dss.pdf.PdfModificationImpl;
import eu.europa.esig.dss.pdf.visible.ImageUtils;
import eu.europa.esig.dss.utils.Utils;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfModificationDetectionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PdfModificationDetectionUtils.class);

    private PdfModificationDetectionUtils() {
    }

    public static List<PdfModification> getAnnotationOverlaps(PdfDocumentReader reader) throws IOException {
        ArrayList<PdfModification> annotationOverlaps = new ArrayList<PdfModification>();
        block0: for (int pageNumber = 1; pageNumber <= reader.getNumberOfPages(); ++pageNumber) {
            List<PdfAnnotation> pdfAnnotations = reader.getPdfAnnotations(pageNumber);
            Iterator<PdfAnnotation> iterator = pdfAnnotations.iterator();
            while (iterator.hasNext()) {
                PdfAnnotation annotation = iterator.next();
                iterator.remove();
                if (!PdfModificationDetectionUtils.isAnnotationBoxOverlapping(annotation.getAnnotationBox(), pdfAnnotations)) continue;
                annotationOverlaps.add(new PdfModificationImpl(pageNumber));
                continue block0;
            }
        }
        return annotationOverlaps;
    }

    public static boolean isAnnotationBoxOverlapping(AnnotationBox annotationBox, List<PdfAnnotation> pdfAnnotations) {
        if (annotationBox.getWidth() == 0.0f || annotationBox.getHeight() == 0.0f) {
            return false;
        }
        for (PdfAnnotation pdfAnnotation : pdfAnnotations) {
            if (!annotationBox.isOverlap(pdfAnnotation)) continue;
            return true;
        }
        return false;
    }

    public static List<PdfModification> getVisualDifferences(PdfDocumentReader signedRevisionReader, PdfDocumentReader finalRevisionReader) throws IOException {
        ArrayList<PdfModification> visualDifferences = new ArrayList<PdfModification>();
        for (int pageNumber = 1; pageNumber <= signedRevisionReader.getNumberOfPages() && pageNumber <= finalRevisionReader.getNumberOfPages(); ++pageNumber) {
            List<PdfAnnotation> finalAnnotations;
            List<PdfAnnotation> signedAnnotations;
            List<PdfAnnotation> addedAnnotations;
            BufferedImage finalScreenshot;
            BufferedImage signedScreenshot = signedRevisionReader.generateImageScreenshot(pageNumber);
            if (ImageUtils.imagesEqual(signedScreenshot, finalScreenshot = finalRevisionReader.generateImageScreenshotWithoutAnnotations(pageNumber, addedAnnotations = PdfModificationDetectionUtils.getUpdatedAnnotations(signedAnnotations = signedRevisionReader.getPdfAnnotations(pageNumber), finalAnnotations = finalRevisionReader.getPdfAnnotations(pageNumber))))) continue;
            LOG.warn("A visual difference found on page {} between a signed revision and the final document!", (Object)pageNumber);
            visualDifferences.add(new PdfModificationImpl(pageNumber));
        }
        return visualDifferences;
    }

    public static List<PdfModification> getPagesDifferences(PdfDocumentReader signedRevisionReader, PdfDocumentReader finalRevisionReader) {
        int signedPages = signedRevisionReader.getNumberOfPages();
        int finalPages = finalRevisionReader.getNumberOfPages();
        int maxNumberOfPages = Math.max(signedPages, finalPages);
        int minNumberOfPages = Math.min(signedPages, finalPages);
        ArrayList<PdfModification> missingPages = new ArrayList<PdfModification>();
        for (int ii = maxNumberOfPages; ii > minNumberOfPages; --ii) {
            missingPages.add(new PdfModificationImpl(ii));
        }
        if (Utils.isCollectionNotEmpty(missingPages)) {
            LOG.warn("The provided PDF file contains {} additional pages against the signed revision!", (Object)(maxNumberOfPages - minNumberOfPages));
        }
        return missingPages;
    }

    private static List<PdfAnnotation> getUpdatedAnnotations(List<PdfAnnotation> signedAnnotations, List<PdfAnnotation> finalAnnotations) {
        ArrayList<PdfAnnotation> updatesAnnotations = new ArrayList<PdfAnnotation>();
        for (PdfAnnotation annotationBox : finalAnnotations) {
            if (signedAnnotations.contains(annotationBox)) continue;
            updatesAnnotations.add(annotationBox);
        }
        return updatesAnnotations;
    }
}

