/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.visible;

import eu.europa.esig.dss.enumerations.VisualSignatureRotation;

public class ImageRotationUtils {
    public static final String SUPPORTED_ANGLES_ERROR_MESSAGE = "rotation angle must be 90, 180, 270 or 360 (0)";
    public static final int ANGLE_0 = 0;
    public static final int ANGLE_90 = 90;
    public static final int ANGLE_180 = 180;
    public static final int ANGLE_270 = 270;
    public static final int ANGLE_360 = 360;

    private ImageRotationUtils() {
    }

    private static boolean needRotation(VisualSignatureRotation visualSignatureRotation) {
        return visualSignatureRotation != null && !VisualSignatureRotation.NONE.equals((Object)visualSignatureRotation);
    }

    public static int getRotation(VisualSignatureRotation visualSignatureRotation) {
        return ImageRotationUtils.getRotation(visualSignatureRotation, 0);
    }

    public static int getRotation(VisualSignatureRotation visualSignatureRotation, int pageRotation) {
        int rotate = 360;
        if (ImageRotationUtils.needRotation(visualSignatureRotation)) {
            switch (visualSignatureRotation) {
                case AUTOMATIC: {
                    rotate = 360 - pageRotation;
                    break;
                }
                case ROTATE_90: {
                    rotate = 90;
                    break;
                }
                case ROTATE_180: {
                    rotate = 180;
                    break;
                }
                case ROTATE_270: {
                    rotate = 270;
                    break;
                }
                default: {
                    throw new IllegalStateException(SUPPORTED_ANGLES_ERROR_MESSAGE);
                }
            }
        }
        return rotate;
    }

    public static boolean isSwapOfDimensionsRequired(int rotation) {
        return 90 == rotation || 270 == rotation;
    }
}

