/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.visible;

import eu.europa.esig.dss.pades.SignatureImageTextParameters;
import eu.europa.esig.dss.pdf.AnnotationBox;
import eu.europa.esig.dss.pdf.visible.DSSFontMetrics;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class TextFitter {
    private static final int FONT_SIZE_COEFFICIENT = 32;

    public static Result fitSignatureText(SignatureImageTextParameters textParameters, float properTextSize, DSSFontMetrics fontMetrics, AnnotationBox textBox) {
        List<String> lines = Arrays.asList(fontMetrics.getLines(textParameters.getText()));
        if (Utils.isCollectionEmpty(lines)) {
            throw new IllegalArgumentException("No text has been provided!");
        }
        switch (textParameters.getTextWrapping()) {
            case FILL_BOX: {
                float fontSize = TextFitter.getMaxPossibleFontSize(textBox, lines, fontMetrics);
                return new Result(fontSize, textParameters.getText());
            }
            case FILL_BOX_AND_LINEBREAK: {
                return TextFitter.getBestMaxFontSize(textBox, lines, fontMetrics);
            }
            case FONT_BASED: {
                return new Result(properTextSize, textParameters.getText());
            }
        }
        throw new IllegalArgumentException(String.format("The TextWrapping '%s' is not supported!", textParameters.getTextWrapping()));
    }

    private static float getMaxPossibleFontSize(AnnotationBox textBox, List<String> lines, DSSFontMetrics fontMetrics) {
        float maxFontSizeByHeight = TextFitter.getMaxFontSizeByHeight(textBox.getHeight(), lines, fontMetrics);
        float maxFontSizeByWidth = TextFitter.getMaxFontSizeByWidth(textBox.getWidth(), lines, fontMetrics);
        return Math.min(maxFontSizeByHeight, maxFontSizeByWidth);
    }

    private static float getMaxFontSizeByHeight(float textBoxHeight, List<String> lines, DSSFontMetrics fontMetrics) {
        float maxLineHeight = textBoxHeight / (float)lines.size();
        return maxLineHeight / (fontMetrics.getHeight(lines.iterator().next(), 32.0f) / 32.0f);
    }

    private static float getMaxFontSizeByWidth(float textBoxWidth, List<String> lines, DSSFontMetrics fontMetrics) {
        float longestLineWidth = TextFitter.getLongestLineWidth(lines, fontMetrics);
        return textBoxWidth / longestLineWidth;
    }

    private static float getLongestLineWidth(List<String> lines, DSSFontMetrics fontMetrics) {
        float longestLineWidth = -1.0f;
        for (String line : lines) {
            float lineWidth = fontMetrics.getWidth(line, 32.0f) / 32.0f;
            if (!(lineWidth > longestLineWidth)) continue;
            longestLineWidth = lineWidth;
        }
        return longestLineWidth;
    }

    private static Result getBestMaxFontSize(AnnotationBox textBox, List<String> lines, DSSFontMetrics fontMetrics) {
        float maxFontSizeByWidth;
        StringBuilder sb = new StringBuilder();
        List<String> wrappedLines = lines;
        float maxFontSizeByHeight = TextFitter.getMaxFontSizeByHeight(textBox.getHeight(), wrappedLines, fontMetrics);
        if (maxFontSizeByHeight > (maxFontSizeByWidth = TextFitter.getMaxFontSizeByWidth(textBox.getWidth(), wrappedLines, fontMetrics))) {
            int maxPossibleLinesNumber = TextFitter.getMaxPossibleLinesNumber(lines);
            for (int ii = 0; ii < maxPossibleLinesNumber - lines.size() && maxFontSizeByWidth <= maxFontSizeByHeight; ++ii) {
                List<String> newLines = TextFitter.wrapLineWithMetrics(lines, fontMetrics, sb, maxFontSizeByHeight, textBox.getWidth(), ii + 1);
                wrappedLines = newLines;
                float newFontSizeByHeight = TextFitter.getMaxFontSizeByHeight(textBox.getHeight(), newLines, fontMetrics);
                float newFontSizeByWidth = TextFitter.getMaxFontSizeByWidth(textBox.getWidth(), newLines, fontMetrics);
                if (maxFontSizeByHeight == newFontSizeByHeight || maxFontSizeByWidth == newFontSizeByWidth) {
                    if (!(maxFontSizeByHeight > maxFontSizeByWidth)) break;
                    maxFontSizeByHeight = newFontSizeByWidth;
                    continue;
                }
                maxFontSizeByHeight = newFontSizeByHeight;
                maxFontSizeByWidth = newFontSizeByWidth;
            }
        }
        float computedFontSize = Math.min(maxFontSizeByHeight, maxFontSizeByWidth);
        String joinedText = Utils.joinStrings(wrappedLines, (String)"\n");
        return new Result(computedFontSize, joinedText);
    }

    private static int getMaxPossibleLinesNumber(List<String> lines) {
        int maxLinesNumber = 0;
        for (String line : lines) {
            String[] words = line.split(" ");
            maxLinesNumber += words.length;
        }
        return maxLinesNumber;
    }

    private static List<String> wrapLineWithMetrics(List<String> lines, DSSFontMetrics fontMetrics, StringBuilder sb, float fontSize, float maxWidth, int linesToAdd) {
        List<String> result = lines;
        for (int ii = 0; ii < linesToAdd; ++ii) {
            ArrayList<String> wrappedLines = new ArrayList<String>();
            String longestLineToDivide = null;
            float longestLineWidth = -1.0f;
            for (String line : result) {
                float lineWidth = fontMetrics.getWidth(line, 32.0f);
                if (!(maxWidth < lineWidth) || !(longestLineWidth < lineWidth)) continue;
                longestLineToDivide = line;
                longestLineWidth = lineWidth;
            }
            if (longestLineToDivide == null) {
                return result;
            }
            block2: for (String line : result) {
                if (longestLineToDivide.equals(line)) {
                    String[] words = line.split(" ");
                    int firstWord = 0;
                    for (int lastWord = words.length - 1; lastWord >= firstWord; --lastWord) {
                        String word;
                        String stringToAdd = null;
                        if (lastWord == firstWord) {
                            stringToAdd = words[firstWord];
                            firstWord = lastWord + 1;
                        } else {
                            for (int j = firstWord; j <= lastWord; ++j) {
                                if (j > firstWord) {
                                    sb.append(' ');
                                }
                                word = words[j];
                                sb.append(word);
                            }
                            String substring = sb.toString();
                            if (fontMetrics.getWidth(substring, fontSize) <= maxWidth) {
                                stringToAdd = substring;
                            }
                            sb.setLength(0);
                        }
                        if (!Utils.isStringNotEmpty((String)stringToAdd)) continue;
                        wrappedLines.add(stringToAdd);
                        for (int j = lastWord + 1; j < words.length; ++j) {
                            if (j > lastWord + 1) {
                                sb.append(' ');
                            }
                            word = words[j];
                            sb.append(word);
                        }
                        String substringAfter = sb.toString();
                        if (Utils.isStringNotEmpty((String)substringAfter)) {
                            wrappedLines.add(substringAfter);
                        }
                        sb.setLength(0);
                        continue block2;
                    }
                    continue;
                }
                wrappedLines.add(line);
            }
            result = wrappedLines;
        }
        return result;
    }

    public static final class Result {
        private final float size;
        private final String text;

        private Result(float size, String text) {
            this.size = size;
            this.text = text;
        }

        public float getSize() {
            return this.size;
        }

        public String getText() {
            return this.text;
        }
    }
}

