/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.timestamp;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSMessageDigest;
import eu.europa.esig.dss.model.TimestampBinary;
import eu.europa.esig.dss.pades.PAdESTimestampParameters;
import eu.europa.esig.dss.pdf.PDFSignatureService;
import eu.europa.esig.dss.pdf.ServiceLoaderPdfObjFactory;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import java.util.Objects;

public class PAdESTimestampService {
    private final TSPSource tspSource;
    private final PDFSignatureService pdfSignatureService;

    public PAdESTimestampService(TSPSource tspSource) {
        this(tspSource, new ServiceLoaderPdfObjFactory().newArchiveTimestampService());
    }

    public PAdESTimestampService(TSPSource tspSource, PDFSignatureService pdfSignatureService) {
        Objects.requireNonNull(tspSource, "TSPSource shall be provided!");
        Objects.requireNonNull(pdfSignatureService, "PDFSignatureService shall be provided!");
        this.tspSource = tspSource;
        this.pdfSignatureService = pdfSignatureService;
    }

    public DSSDocument timestampDocument(DSSDocument document, PAdESTimestampParameters params) {
        DSSMessageDigest messageDigest = this.pdfSignatureService.messageDigest(document, params);
        TimestampBinary timeStampToken = this.tspSource.getTimeStampResponse(messageDigest.getAlgorithm(), messageDigest.getValue());
        byte[] encoded = DSSASN1Utils.getDEREncoded((TimestampBinary)timeStampToken);
        return this.pdfSignatureService.sign(document, encoded, params);
    }
}

