/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation.timestamp;

import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.pades.validation.PdfRevision;
import eu.europa.esig.dss.pades.validation.dss.PdfDssDictCRLSource;
import eu.europa.esig.dss.pades.validation.dss.PdfDssDictCertificateSource;
import eu.europa.esig.dss.pades.validation.dss.PdfDssDictOCSPSource;
import eu.europa.esig.dss.pades.validation.dss.PdfVriDictSource;
import eu.europa.esig.dss.pades.validation.timestamp.PdfTimestampToken;
import eu.europa.esig.dss.pdf.PdfDocDssRevision;
import eu.europa.esig.dss.pdf.PdfDocTimestampRevision;
import eu.europa.esig.dss.spi.x509.ListCertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.ListRevocationSource;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.spi.x509.tsp.TimestampedReference;
import eu.europa.esig.dss.validation.timestamp.AbstractTimestampSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PdfRevisionTimestampSource
extends AbstractTimestampSource {
    private final PdfRevision pdfRevision;
    private final ListCertificateSource certificateSource;
    private final ListRevocationSource<CRL> crlSource;
    private final ListRevocationSource<OCSP> ocspSource;

    public PdfRevisionTimestampSource(PdfRevision pdfRevision, ListCertificateSource certificateSource, ListRevocationSource<CRL> crlSource, ListRevocationSource<OCSP> ocspSource) {
        this.pdfRevision = pdfRevision;
        this.certificateSource = certificateSource;
        this.crlSource = crlSource;
        this.ocspSource = ocspSource;
    }

    public List<TimestampedReference> getIncorporatedReferences() {
        if (this.pdfRevision instanceof PdfDocTimestampRevision) {
            PdfDocTimestampRevision pdfDocTimestampRevision = (PdfDocTimestampRevision)this.pdfRevision;
            PdfTimestampToken timestampToken = pdfDocTimestampRevision.getTimestampToken();
            return this.getReferencesFromTimestamp(timestampToken, this.certificateSource, this.crlSource, this.ocspSource);
        }
        if (this.pdfRevision instanceof PdfDocDssRevision) {
            PdfDocDssRevision pdfDocDssRevision = (PdfDocDssRevision)this.pdfRevision;
            ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
            PdfDssDictCertificateSource dssCertificateSource = pdfDocDssRevision.getCertificateSource();
            this.addReferences(references, this.createReferencesForCertificates(dssCertificateSource.getCertificates()));
            PdfDssDictCRLSource dssCRLSource = pdfDocDssRevision.getCRLSource();
            this.addReferences(references, this.createReferencesForCRLBinaries(dssCRLSource.getDSSDictionaryBinaries()));
            this.addReferences(references, this.createReferencesForCRLBinaries(dssCRLSource.getVRIDictionaryBinaries()));
            PdfDssDictOCSPSource dssOCSPSource = pdfDocDssRevision.getOCSPSource();
            this.addReferences(references, this.createReferencesForOCSPBinaries(dssOCSPSource.getDSSDictionaryBinaries(), this.certificateSource));
            this.addReferences(references, this.createReferencesForOCSPBinaries(dssOCSPSource.getVRIDictionaryBinaries(), this.certificateSource));
            return references;
        }
        return Collections.emptyList();
    }

    public TimestampToken getVRITimestampToken(String vriKey) {
        if (this.pdfRevision instanceof PdfDocDssRevision) {
            PdfDocDssRevision pdfDocDssRevision = (PdfDocDssRevision)this.pdfRevision;
            PdfVriDictSource pdfVriDictTimestampSource = new PdfVriDictSource(pdfDocDssRevision.getDssDictionary(), vriKey);
            return pdfVriDictTimestampSource.getTimestampToken();
        }
        return null;
    }
}

