/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf;

import eu.europa.esig.dss.pdf.AbstractPdfDssDict;
import eu.europa.esig.dss.pdf.DSSDictionaryExtractionUtils;
import eu.europa.esig.dss.pdf.PdfDict;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class PdfVriDict
extends AbstractPdfDssDict {
    private static final long serialVersionUID = -1545254066906625419L;
    private final String name;
    private final Date tuTime;
    private final byte[] tsStream;

    public PdfVriDict(String name, PdfDict vriDict) {
        super(vriDict);
        this.name = name;
        this.tuTime = DSSDictionaryExtractionUtils.getDictionaryCreationTime(vriDict);
        this.tsStream = DSSDictionaryExtractionUtils.getTimestampBinaries(vriDict);
    }

    @Override
    protected String getDictionaryName() {
        return "VRI";
    }

    @Override
    protected String getCertArrayDictionaryName() {
        return "Cert";
    }

    @Override
    protected String getCRLArrayDictionaryName() {
        return "CRL";
    }

    @Override
    protected String getOCSPArrayDictionaryName() {
        return "OCSP";
    }

    public String getName() {
        return this.name;
    }

    @Override
    public List<PdfVriDict> getVRIs() {
        return Collections.emptyList();
    }

    public Date getTUTime() {
        return this.tuTime;
    }

    public byte[] getTSStream() {
        return this.tsStream;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PdfVriDict other = (PdfVriDict)obj;
        return this.name.equals(other.name);
    }
}

