/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.reports;

import eu.europa.esig.dss.jaxb.detailedreport.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.jaxb.detailedreport.XmlSignature;
import eu.europa.esig.dss.jaxb.detailedreport.XmlValidationProcessTimestamps;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.policy.Context;
import eu.europa.esig.dss.validation.policy.rules.Indication;
import eu.europa.esig.dss.validation.policy.rules.SubIndication;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DetailedReport {
    private final eu.europa.esig.dss.jaxb.detailedreport.DetailedReport jaxbDetailedReport;

    public DetailedReport(eu.europa.esig.dss.jaxb.detailedreport.DetailedReport jaxbDetailedReport) {
        this.jaxbDetailedReport = jaxbDetailedReport;
    }

    public Indication getBasicBuildingBlocksIndication(String tokenId) {
        List basicBuildingBlocks = this.jaxbDetailedReport.getBasicBuildingBlocks();
        for (XmlBasicBuildingBlocks xmlBasicBuildingBlocks : basicBuildingBlocks) {
            if (!Utils.areStringsEqual((String)xmlBasicBuildingBlocks.getId(), (String)tokenId)) continue;
            return xmlBasicBuildingBlocks.getConclusion().getIndication();
        }
        return null;
    }

    public SubIndication getBasicBuildingBlocksSubIndication(String tokenId) {
        List basicBuildingBlocks = this.jaxbDetailedReport.getBasicBuildingBlocks();
        for (XmlBasicBuildingBlocks xmlBasicBuildingBlocks : basicBuildingBlocks) {
            if (!Utils.areStringsEqual((String)xmlBasicBuildingBlocks.getId(), (String)tokenId)) continue;
            return xmlBasicBuildingBlocks.getConclusion().getSubIndication();
        }
        return null;
    }

    public int getBasicBuildingBlocksNumber() {
        return this.jaxbDetailedReport.getBasicBuildingBlocks().size();
    }

    public String getBasicBuildingBlocksSignatureId(int index) {
        XmlBasicBuildingBlocks bbb;
        List bbbs = this.jaxbDetailedReport.getBasicBuildingBlocks();
        if (Utils.collectionSize((Collection)bbbs) >= index && (bbb = (XmlBasicBuildingBlocks)this.jaxbDetailedReport.getBasicBuildingBlocks().get(index)) != null) {
            return bbb.getId();
        }
        return null;
    }

    public List<String> getSignatureIds() {
        ArrayList<String> result = new ArrayList<String>();
        List bbbs = this.jaxbDetailedReport.getBasicBuildingBlocks();
        for (XmlBasicBuildingBlocks bbb : bbbs) {
            if (Context.SIGNATURE != bbb.getType() && Context.COUNTER_SIGNATURE != bbb.getType()) continue;
            result.add(bbb.getId());
        }
        return result;
    }

    public List<String> getTimestampIds() {
        ArrayList<String> result = new ArrayList<String>();
        List bbbs = this.jaxbDetailedReport.getBasicBuildingBlocks();
        for (XmlBasicBuildingBlocks bbb : bbbs) {
            if (Context.TIMESTAMP != bbb.getType()) continue;
            result.add(bbb.getId());
        }
        return result;
    }

    public List<String> getRevocationIds() {
        ArrayList<String> result = new ArrayList<String>();
        List bbbs = this.jaxbDetailedReport.getBasicBuildingBlocks();
        for (XmlBasicBuildingBlocks bbb : bbbs) {
            if (Context.REVOCATION != bbb.getType()) continue;
            result.add(bbb.getId());
        }
        return result;
    }

    public Indication getBasicValidationIndication(String signatureId) {
        XmlSignature signature = this.getXmlSignatureById(signatureId);
        if (signature != null && signature.getValidationProcessBasicSignatures() != null && signature.getValidationProcessBasicSignatures().getConclusion() != null) {
            return signature.getValidationProcessBasicSignatures().getConclusion().getIndication();
        }
        return null;
    }

    public SubIndication getBasicValidationSubIndication(String signatureId) {
        XmlSignature signature = this.getXmlSignatureById(signatureId);
        if (signature != null && signature.getValidationProcessBasicSignatures() != null && signature.getValidationProcessBasicSignatures().getConclusion() != null) {
            return signature.getValidationProcessBasicSignatures().getConclusion().getSubIndication();
        }
        return null;
    }

    public Indication getTimestampValidationIndication(String timestampId) {
        XmlValidationProcessTimestamps timestampValidationById = this.getTimestampValidationById(timestampId);
        if (timestampValidationById != null && timestampValidationById.getConclusion() != null) {
            return timestampValidationById.getConclusion().getIndication();
        }
        return null;
    }

    public SubIndication getTimestampValidationSubIndication(String timestampId) {
        XmlValidationProcessTimestamps timestampValidationById = this.getTimestampValidationById(timestampId);
        if (timestampValidationById != null && timestampValidationById.getConclusion() != null) {
            return timestampValidationById.getConclusion().getSubIndication();
        }
        return null;
    }

    public Indication getLongTermValidationIndication(String signatureId) {
        XmlSignature signature = this.getXmlSignatureById(signatureId);
        if (signature != null && signature.getValidationProcessLongTermData() != null && signature.getValidationProcessLongTermData().getConclusion() != null) {
            return signature.getValidationProcessLongTermData().getConclusion().getIndication();
        }
        return null;
    }

    public SubIndication getLongTermValidationSubIndication(String signatureId) {
        XmlSignature signature = this.getXmlSignatureById(signatureId);
        if (signature != null && signature.getValidationProcessLongTermData() != null && signature.getValidationProcessLongTermData().getConclusion() != null) {
            return signature.getValidationProcessLongTermData().getConclusion().getSubIndication();
        }
        return null;
    }

    public Indication getArchiveDataValidationIndication(String signatureId) {
        XmlSignature signature = this.getXmlSignatureById(signatureId);
        if (signature != null && signature.getValidationProcessArchivalData() != null && signature.getValidationProcessArchivalData().getConclusion() != null) {
            return signature.getValidationProcessArchivalData().getConclusion().getIndication();
        }
        return null;
    }

    public SubIndication getArchiveDataValidationSubIndication(String signatureId) {
        XmlSignature signature = this.getXmlSignatureById(signatureId);
        if (signature != null && signature.getValidationProcessArchivalData() != null && signature.getValidationProcessArchivalData().getConclusion() != null) {
            return signature.getValidationProcessArchivalData().getConclusion().getSubIndication();
        }
        return null;
    }

    private XmlSignature getXmlSignatureById(String signatureId) {
        List signatures = this.jaxbDetailedReport.getSignatures();
        if (Utils.isCollectionNotEmpty((Collection)signatures)) {
            for (XmlSignature xmlSignature : signatures) {
                if (!Utils.areStringsEqual((String)signatureId, (String)xmlSignature.getId())) continue;
                return xmlSignature;
            }
        }
        return null;
    }

    private XmlValidationProcessTimestamps getTimestampValidationById(String timestampId) {
        List signatures = this.jaxbDetailedReport.getSignatures();
        if (Utils.isCollectionNotEmpty((Collection)signatures)) {
            for (XmlSignature xmlSignature : signatures) {
                List validationTimestamps = xmlSignature.getValidationProcessTimestamps();
                if (!Utils.isCollectionNotEmpty((Collection)validationTimestamps)) continue;
                for (XmlValidationProcessTimestamps tspValidation : validationTimestamps) {
                    if (!Utils.areStringsEqual((String)tspValidation.getId(), (String)timestampId)) continue;
                    return tspValidation;
                }
            }
        }
        return null;
    }

    public eu.europa.esig.dss.jaxb.detailedreport.DetailedReport getJAXBModel() {
        return this.jaxbDetailedReport;
    }
}

