/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.reports;

import eu.europa.esig.dss.jaxb.simplereport.XmlSignature;
import eu.europa.esig.dss.jaxb.simplereport.XmlSignatureLevel;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.SignatureQualification;
import eu.europa.esig.dss.validation.policy.rules.Indication;
import eu.europa.esig.dss.validation.policy.rules.SubIndication;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class SimpleReport {
    private final eu.europa.esig.dss.jaxb.simplereport.SimpleReport simpleReport;

    public SimpleReport(eu.europa.esig.dss.jaxb.simplereport.SimpleReport simpleReport) {
        this.simpleReport = simpleReport;
    }

    public Date getValidationTime() {
        return this.simpleReport.getValidationTime();
    }

    public Indication getIndication(String signatureId) {
        XmlSignature signature = this.getSignatureById(signatureId);
        if (signature != null) {
            return signature.getIndication();
        }
        return null;
    }

    public SubIndication getSubIndication(String signatureId) {
        XmlSignature signature = this.getSignatureById(signatureId);
        if (signature != null) {
            return signature.getSubIndication();
        }
        return null;
    }

    public boolean isSignatureValid(String signatureId) {
        Indication indicationValue = this.getIndication(signatureId);
        return Indication.TOTAL_PASSED.equals((Object)indicationValue);
    }

    public SignatureQualification getSignatureQualification(String signatureId) {
        XmlSignature signature = this.getSignatureById(signatureId);
        XmlSignatureLevel signatureLevel = signature.getSignatureLevel();
        SignatureQualification qualif = SignatureQualification.NA;
        if (signatureLevel != null) {
            qualif = signatureLevel.getValue();
        }
        return qualif;
    }

    public List<String> getSignatureIdList() {
        ArrayList<String> signatureIdList = new ArrayList<String>();
        List signatures = this.simpleReport.getSignature();
        if (Utils.isCollectionNotEmpty((Collection)signatures)) {
            for (XmlSignature xmlSignature : signatures) {
                signatureIdList.add(xmlSignature.getId());
            }
        }
        return signatureIdList;
    }

    public String getFirstSignatureId() {
        List<String> signatureIdList = this.getSignatureIdList();
        if (signatureIdList.size() > 0) {
            return signatureIdList.get(0);
        }
        return null;
    }

    public List<String> getInfo(String signatureId) {
        XmlSignature signature = this.getSignatureById(signatureId);
        if (signature != null) {
            return signature.getInfos();
        }
        return Collections.emptyList();
    }

    public List<String> getErrors(String signatureId) {
        XmlSignature signature = this.getSignatureById(signatureId);
        if (signature != null) {
            return signature.getErrors();
        }
        return Collections.emptyList();
    }

    public List<String> getWarnings(String signatureId) {
        XmlSignature signature = this.getSignatureById(signatureId);
        if (signature != null) {
            return signature.getWarnings();
        }
        return Collections.emptyList();
    }

    public String getSignatureFormat(String signatureId) {
        XmlSignature xmlSignature = this.getSignatureById(signatureId);
        if (xmlSignature != null) {
            return xmlSignature.getSignatureFormat();
        }
        return "";
    }

    public Date getSigningTime(String signatureId) {
        XmlSignature xmlSignature = this.getSignatureById(signatureId);
        if (xmlSignature != null) {
            return xmlSignature.getSigningTime();
        }
        return null;
    }

    public String getSignedBy(String signatureId) {
        XmlSignature xmlSignature = this.getSignatureById(signatureId);
        if (xmlSignature != null) {
            return xmlSignature.getSignedBy();
        }
        return "";
    }

    public int getSignaturesCount() {
        return this.simpleReport.getSignaturesCount();
    }

    public int getValidSignaturesCount() {
        return this.simpleReport.getValidSignaturesCount();
    }

    private XmlSignature getSignatureById(String signatureId) {
        List signatures = this.simpleReport.getSignature();
        if (Utils.isCollectionNotEmpty((Collection)signatures)) {
            for (XmlSignature xmlSignature : signatures) {
                if (!Utils.areStringsEqual((String)signatureId, (String)xmlSignature.getId())) continue;
                return xmlSignature;
            }
        }
        return null;
    }

    public eu.europa.esig.dss.jaxb.simplereport.SimpleReport getJaxbModel() {
        return this.simpleReport;
    }
}

