/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.reports.wrapper;

import eu.europa.esig.dss.jaxb.diagnostic.XmlBasicSignature;
import eu.europa.esig.dss.jaxb.diagnostic.XmlCertificate;
import eu.europa.esig.dss.jaxb.diagnostic.XmlChainItem;
import eu.europa.esig.dss.jaxb.diagnostic.XmlDigestAlgoAndValue;
import eu.europa.esig.dss.jaxb.diagnostic.XmlDistinguishedName;
import eu.europa.esig.dss.jaxb.diagnostic.XmlOID;
import eu.europa.esig.dss.jaxb.diagnostic.XmlRevocation;
import eu.europa.esig.dss.jaxb.diagnostic.XmlSigningCertificate;
import eu.europa.esig.dss.jaxb.diagnostic.XmlTrustedService;
import eu.europa.esig.dss.jaxb.diagnostic.XmlTrustedServiceProvider;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.reports.wrapper.AbstractTokenProxy;
import eu.europa.esig.dss.validation.reports.wrapper.RevocationWrapper;
import eu.europa.esig.dss.validation.reports.wrapper.TrustedServiceWrapper;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class CertificateWrapper
extends AbstractTokenProxy {
    private final XmlCertificate certificate;

    public CertificateWrapper(XmlCertificate certificate) {
        this.certificate = certificate;
    }

    @Override
    public String getId() {
        return this.certificate.getId();
    }

    @Override
    protected XmlBasicSignature getCurrentBasicSignature() {
        return this.certificate.getBasicSignature();
    }

    @Override
    protected List<XmlChainItem> getCurrentCertificateChain() {
        return this.certificate.getCertificateChain();
    }

    @Override
    protected XmlSigningCertificate getCurrentSigningCertificate() {
        return this.certificate.getSigningCertificate();
    }

    public boolean isTrusted() {
        return this.certificate.isTrusted();
    }

    public List<String> getKeyUsages() {
        List keyUsageBits = this.certificate.getKeyUsageBits();
        if (Utils.isCollectionNotEmpty((Collection)keyUsageBits)) {
            return keyUsageBits;
        }
        return new ArrayList<String>();
    }

    public boolean isRevocationDataAvailable() {
        return Utils.isCollectionNotEmpty((Collection)this.certificate.getRevocations());
    }

    public Set<RevocationWrapper> getRevocationData() {
        if (this.isRevocationDataAvailable()) {
            List revocation = this.certificate.getRevocations();
            HashSet<RevocationWrapper> result = new HashSet<RevocationWrapper>();
            for (XmlRevocation xmlRevocationType : revocation) {
                result.add(new RevocationWrapper(xmlRevocationType));
            }
            return result;
        }
        return Collections.emptySet();
    }

    public RevocationWrapper getLatestRevocationData() {
        RevocationWrapper latest = null;
        for (RevocationWrapper revoc : this.getRevocationData()) {
            if (latest != null && (latest.getProductionDate() == null || revoc == null || revoc.getProductionDate() == null || !revoc.getProductionDate().after(latest.getProductionDate()))) continue;
            latest = revoc;
        }
        return latest;
    }

    public boolean isIdPkixOcspNoCheck() {
        return Utils.isTrue((Boolean)this.certificate.isIdPkixOcspNoCheck());
    }

    public boolean isIdKpOCSPSigning() {
        return Utils.isTrue((Boolean)this.certificate.isIdKpOCSPSigning());
    }

    public Date getNotBefore() {
        return this.certificate.getNotBefore();
    }

    public Date getNotAfter() {
        return this.certificate.getNotAfter();
    }

    public Date getCertificateTSPServiceExpiredCertsRevocationInfo() {
        List trustedServiceProviders = this.certificate.getTrustedServiceProviders();
        if (Utils.isCollectionNotEmpty((Collection)trustedServiceProviders)) {
            for (XmlTrustedServiceProvider trustedServiceProvider : trustedServiceProviders) {
                List trustedServices = trustedServiceProvider.getTrustedServices();
                Iterator iterator = trustedServices.iterator();
                if (!iterator.hasNext()) continue;
                XmlTrustedService xmlTrustedService = (XmlTrustedService)iterator.next();
                return xmlTrustedService.getExpiredCertsRevocationInfo();
            }
        }
        return null;
    }

    public boolean isRevoked() {
        RevocationWrapper latestRevocationData = this.getLatestRevocationData();
        return latestRevocationData != null && latestRevocationData.isStatus() && latestRevocationData.getRevocationDate() != null;
    }

    public boolean isValidCertificate() {
        boolean signatureValid = this.certificate.getBasicSignature() != null && this.certificate.getBasicSignature().isSignatureValid();
        RevocationWrapper latestRevocationData = this.getLatestRevocationData();
        boolean revocationValid = latestRevocationData != null && latestRevocationData.isStatus();
        boolean trusted = this.certificate.isTrusted();
        boolean validity = signatureValid && (trusted || revocationValid);
        return validity;
    }

    public String getSerialNumber() {
        BigInteger serialNumber = this.certificate.getSerialNumber();
        return serialNumber == null ? "" : serialNumber.toString();
    }

    public String getCommonName() {
        String cn = this.certificate.getCommonName();
        return cn == null ? "" : cn;
    }

    public String getCountryName() {
        String c = this.certificate.getCountryName();
        return c == null ? "" : c;
    }

    public String getGivenName() {
        String givenName = this.certificate.getGivenName();
        return givenName == null ? "" : givenName;
    }

    public String getOrganizationName() {
        String o = this.certificate.getOrganizationName();
        return o == null ? "" : o;
    }

    public String getOrganizationalUnit() {
        String ou = this.certificate.getOrganizationalUnit();
        return ou == null ? "" : ou;
    }

    public String getSurname() {
        String surname = this.certificate.getSurname();
        return surname == null ? "" : surname;
    }

    public String getPseudo() {
        String pseudo = this.certificate.getPseudonym();
        return pseudo == null ? "" : pseudo;
    }

    public List<XmlDigestAlgoAndValue> getDigestAlgoAndValues() {
        return this.certificate.getDigestAlgoAndValues();
    }

    public boolean hasTrustedServices() {
        List tsps = this.certificate.getTrustedServiceProviders();
        return Utils.isCollectionNotEmpty((Collection)tsps);
    }

    public List<TrustedServiceWrapper> getTrustedServices() {
        ArrayList<TrustedServiceWrapper> result = new ArrayList<TrustedServiceWrapper>();
        List tsps = this.certificate.getTrustedServiceProviders();
        if (Utils.isCollectionNotEmpty((Collection)tsps)) {
            for (XmlTrustedServiceProvider tsp : tsps) {
                List trustedServices = tsp.getTrustedServices();
                if (!Utils.isCollectionNotEmpty((Collection)trustedServices)) continue;
                for (XmlTrustedService trustedService : trustedServices) {
                    TrustedServiceWrapper wrapper = new TrustedServiceWrapper();
                    wrapper.setCountryCode(tsp.getCountryCode());
                    wrapper.setStatus(trustedService.getStatus());
                    wrapper.setType(trustedService.getServiceType());
                    wrapper.setStartDate(trustedService.getStartDate());
                    wrapper.setEndDate(trustedService.getEndDate());
                    wrapper.setCapturedQualifiers(new ArrayList<String>(trustedService.getCapturedQualifiers()));
                    wrapper.setAdditionalServiceInfos(new ArrayList<String>(trustedService.getAdditionalServiceInfoUris()));
                    result.add(wrapper);
                }
            }
        }
        return result;
    }

    public String getCertificateDN() {
        return this.getFormat(this.certificate.getSubjectDistinguishedName(), "RFC2253");
    }

    public String getCertificateIssuerDN() {
        return this.getFormat(this.certificate.getIssuerDistinguishedName(), "RFC2253");
    }

    private String getFormat(List<XmlDistinguishedName> distinguishedNames, String format) {
        if (Utils.isCollectionNotEmpty(distinguishedNames)) {
            for (XmlDistinguishedName distinguishedName : distinguishedNames) {
                if (!Utils.areStringsEqual((String)distinguishedName.getFormat(), (String)format)) continue;
                return distinguishedName.getValue();
            }
        }
        return "";
    }

    public List<String> getAuthorityInformationAccessUrls() {
        return this.certificate.getAuthorityInformationAccessUrls();
    }

    public List<String> getCRLDistributionPoints() {
        return this.certificate.getCRLDistributionPoints();
    }

    public List<String> getOCSPAccessUrls() {
        return this.certificate.getOCSPAccessUrls();
    }

    public List<String> getPolicyIds() {
        List certificatePolicyIds = this.certificate.getCertificatePolicyIds();
        if (Utils.isCollectionNotEmpty((Collection)certificatePolicyIds)) {
            return this.getOidValues(certificatePolicyIds);
        }
        return Collections.emptyList();
    }

    public List<String> getQCStatementIds() {
        List certificateQCStatementIds = this.certificate.getQCStatementIds();
        if (Utils.isCollectionNotEmpty((Collection)certificateQCStatementIds)) {
            return this.getOidValues(certificateQCStatementIds);
        }
        return Collections.emptyList();
    }

    public List<String> getQCTypes() {
        List certificateQCTypeIds = this.certificate.getQCTypes();
        if (Utils.isCollectionNotEmpty((Collection)certificateQCTypeIds)) {
            return this.getOidValues(certificateQCTypeIds);
        }
        return Collections.emptyList();
    }

    private List<String> getOidValues(List<XmlOID> xmlOids) {
        ArrayList<String> result = new ArrayList<String>();
        for (XmlOID xmlOID : xmlOids) {
            result.add(xmlOID.getValue());
        }
        return result;
    }

    public Set<String> getTrustedListCountryCodes() {
        HashSet<String> countryCodes = new HashSet<String>();
        List trustedServiceProviders = this.certificate.getTrustedServiceProviders();
        for (XmlTrustedServiceProvider tsp : trustedServiceProviders) {
            countryCodes.add(tsp.getCountryCode());
        }
        return countryCodes;
    }

    public byte[] getBinaries() {
        return this.certificate.getBase64Encoded();
    }
}

