/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.reports.wrapper;

import eu.europa.esig.dss.jaxb.diagnostic.XmlBasicSignature;
import eu.europa.esig.dss.jaxb.diagnostic.XmlCertifiedRole;
import eu.europa.esig.dss.jaxb.diagnostic.XmlChainItem;
import eu.europa.esig.dss.jaxb.diagnostic.XmlPolicy;
import eu.europa.esig.dss.jaxb.diagnostic.XmlSignature;
import eu.europa.esig.dss.jaxb.diagnostic.XmlSignatureScope;
import eu.europa.esig.dss.jaxb.diagnostic.XmlSigningCertificate;
import eu.europa.esig.dss.jaxb.diagnostic.XmlStructuralValidation;
import eu.europa.esig.dss.jaxb.diagnostic.XmlTimestamp;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.reports.wrapper.AbstractTokenProxy;
import eu.europa.esig.dss.validation.reports.wrapper.TimestampWrapper;
import eu.europa.esig.dss.x509.TimestampType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SignatureWrapper
extends AbstractTokenProxy {
    private final XmlSignature signature;

    public SignatureWrapper(XmlSignature signature) {
        this.signature = signature;
    }

    @Override
    public String getId() {
        return this.signature.getId();
    }

    @Override
    protected XmlBasicSignature getCurrentBasicSignature() {
        return this.signature.getBasicSignature();
    }

    @Override
    protected List<XmlChainItem> getCurrentCertificateChain() {
        return this.signature.getCertificateChain();
    }

    @Override
    protected XmlSigningCertificate getCurrentSigningCertificate() {
        return this.signature.getSigningCertificate();
    }

    public String getSignatureFilename() {
        return this.signature.getSignatureFilename();
    }

    public boolean isStructuralValidationValid() {
        return this.signature.getStructuralValidation() != null && this.signature.getStructuralValidation().isValid() != false;
    }

    public String getStructuralValidationMessage() {
        XmlStructuralValidation structuralValidation = this.signature.getStructuralValidation();
        if (structuralValidation != null) {
            return structuralValidation.getMessage();
        }
        return "";
    }

    public Date getDateTime() {
        return this.signature.getDateTime();
    }

    public String getContentType() {
        return this.signature.getContentType();
    }

    public String getContentHints() {
        return this.signature.getContentHints();
    }

    public String getContentIdentifier() {
        return this.signature.getContentIdentifier();
    }

    public boolean isCounterSignature() {
        return Utils.isTrue((Boolean)this.signature.isCounterSignature());
    }

    public List<TimestampWrapper> getTimestampList() {
        ArrayList<TimestampWrapper> tsps = new ArrayList<TimestampWrapper>();
        List timestamps = this.signature.getTimestamps();
        if (Utils.isCollectionNotEmpty((Collection)timestamps)) {
            for (XmlTimestamp timestamp : timestamps) {
                tsps.add(new TimestampWrapper(timestamp));
            }
        }
        return tsps;
    }

    public List<TimestampWrapper> getTimestampListByType(TimestampType timestampType) {
        ArrayList<TimestampWrapper> result = new ArrayList<TimestampWrapper>();
        List<TimestampWrapper> all = this.getTimestampList();
        for (TimestampWrapper tsp : all) {
            if (!timestampType.name().equals(tsp.getType())) continue;
            result.add(tsp);
        }
        return result;
    }

    public Set<TimestampWrapper> getAllTimestampsNotArchival() {
        HashSet<TimestampWrapper> notArchivalTimestamps = new HashSet<TimestampWrapper>();
        notArchivalTimestamps.addAll(this.getTimestampListByType(TimestampType.SIGNATURE_TIMESTAMP));
        notArchivalTimestamps.addAll(this.getTimestampListByType(TimestampType.CONTENT_TIMESTAMP));
        notArchivalTimestamps.addAll(this.getTimestampListByType(TimestampType.ALL_DATA_OBJECTS_TIMESTAMP));
        notArchivalTimestamps.addAll(this.getTimestampListByType(TimestampType.INDIVIDUAL_DATA_OBJECTS_TIMESTAMP));
        return notArchivalTimestamps;
    }

    public boolean isSignatureProductionPlacePresent() {
        return this.signature.getSignatureProductionPlace() != null;
    }

    public String getAddress() {
        return this.signature.getSignatureProductionPlace().getAddress();
    }

    public String getCity() {
        return this.signature.getSignatureProductionPlace().getCity();
    }

    public String getCountryName() {
        return this.signature.getSignatureProductionPlace().getCountryName();
    }

    public String getPostalCode() {
        return this.signature.getSignatureProductionPlace().getPostalCode();
    }

    public String getStateOrProvince() {
        return this.signature.getSignatureProductionPlace().getStateOrProvince();
    }

    public String getSignatureFormat() {
        return this.signature.getSignatureFormat();
    }

    public String getErrorMessage() {
        return this.signature.getErrorMessage();
    }

    public boolean isSigningCertificateIdentified() {
        XmlSigningCertificate signingCertificate = this.signature.getSigningCertificate();
        if (signingCertificate != null) {
            return signingCertificate.isDigestValueMatch() != false && signingCertificate.isIssuerSerialMatch() != false;
        }
        return false;
    }

    public String getPolicyId() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null) {
            return policy.getId();
        }
        return "";
    }

    public boolean isBLevelTechnicallyValid() {
        return this.signature.getBasicSignature() != null && this.signature.getBasicSignature().isSignatureValid();
    }

    public boolean isThereXLevel() {
        List<TimestampWrapper> timestampLevelX = this.getTimestampLevelX();
        return Utils.isCollectionNotEmpty(timestampLevelX);
    }

    public boolean isXLevelTechnicallyValid() {
        List<TimestampWrapper> timestamps = this.getTimestampLevelX();
        return this.isTimestampValid(timestamps);
    }

    private List<TimestampWrapper> getTimestampLevelX() {
        List<TimestampWrapper> timestamps = this.getTimestampListByType(TimestampType.VALIDATION_DATA_REFSONLY_TIMESTAMP);
        timestamps.addAll(this.getTimestampListByType(TimestampType.VALIDATION_DATA_TIMESTAMP));
        return timestamps;
    }

    public boolean isThereALevel() {
        List<TimestampWrapper> timestampList = this.getArchiveTimestamps();
        return Utils.isCollectionNotEmpty(timestampList);
    }

    public boolean isALevelTechnicallyValid() {
        List<TimestampWrapper> timestampList = this.getArchiveTimestamps();
        return this.isTimestampValid(timestampList);
    }

    private List<TimestampWrapper> getArchiveTimestamps() {
        return this.getTimestampListByType(TimestampType.ARCHIVE_TIMESTAMP);
    }

    public boolean isThereTLevel() {
        List<TimestampWrapper> timestamps = this.getSignatureTimestamps();
        return Utils.isCollectionNotEmpty(timestamps);
    }

    public boolean isTLevelTechnicallyValid() {
        List<TimestampWrapper> timestampList = this.getSignatureTimestamps();
        return this.isTimestampValid(timestampList);
    }

    private List<TimestampWrapper> getSignatureTimestamps() {
        return this.getTimestampListByType(TimestampType.SIGNATURE_TIMESTAMP);
    }

    private boolean isTimestampValid(List<TimestampWrapper> timestampList) {
        for (TimestampWrapper timestamp : timestampList) {
            boolean signatureValid = timestamp.isSignatureValid();
            boolean messageImprintIntact = timestamp.isMessageImprintDataIntact();
            if (!signatureValid || !messageImprintIntact) continue;
            return true;
        }
        return false;
    }

    public List<String> getTimestampIdsList() {
        ArrayList<String> result = new ArrayList<String>();
        List<TimestampWrapper> timestamps = this.getTimestampList();
        if (Utils.isCollectionNotEmpty(timestamps)) {
            for (TimestampWrapper tsp : timestamps) {
                result.add(tsp.getId());
            }
        }
        return result;
    }

    public String getParentId() {
        return this.signature.getParentId();
    }

    public List<XmlSignatureScope> getSignatureScopes() {
        return this.signature.getSignatureScopes();
    }

    public List<String> getCertifiedRoles() {
        ArrayList<String> result = new ArrayList<String>();
        List certifiedRoles = this.signature.getCertifiedRoles();
        if (Utils.isCollectionNotEmpty((Collection)certifiedRoles)) {
            for (XmlCertifiedRole certifiedRole : certifiedRoles) {
                result.add(certifiedRole.getCertifiedRole());
            }
        }
        return result;
    }

    public List<String> getCommitmentTypeIdentifiers() {
        List commitmentTypeIndications = this.signature.getCommitmentTypeIndication();
        if (Utils.isCollectionNotEmpty((Collection)commitmentTypeIndications)) {
            return commitmentTypeIndications;
        }
        return Collections.emptyList();
    }

    public List<String> getClaimedRoles() {
        List claimedRoles = this.signature.getClaimedRoles();
        if (Utils.isCollectionNotEmpty((Collection)claimedRoles)) {
            return claimedRoles;
        }
        return Collections.emptyList();
    }

    public boolean isPolicyPresent() {
        return this.signature.getPolicy() != null;
    }

    public String getPolicyProcessingError() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null) {
            return policy.getProcessingError();
        }
        return "";
    }

    public boolean getPolicyStatus() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null) {
            return policy.isStatus();
        }
        return false;
    }

    public String getPolicyNotice() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null) {
            return policy.getNotice();
        }
        return "";
    }

    public String getPolicyUrl() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null) {
            return policy.getUrl();
        }
        return "";
    }

    public boolean isPolicyAsn1Processable() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null) {
            return Utils.isTrue((Boolean)policy.isAsn1Processable());
        }
        return false;
    }

    public boolean isPolicyIdentified() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null) {
            return Utils.isTrue((Boolean)policy.isIdentified());
        }
        return false;
    }

    public boolean isPolicyStatus() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null) {
            return Utils.isTrue((Boolean)policy.isStatus());
        }
        return false;
    }

    public String getFormat() {
        return this.signature.getSignatureFormat();
    }
}

