/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.service.http.commons;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.service.http.commons.CommonsDataLoader;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.client.http.Protocol;
import eu.europa.esig.dss.spi.exception.DSSExternalResourceException;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;
import java.io.Serializable;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLSession;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLCertificateLoader
implements Serializable {
    private static final long serialVersionUID = -2560386894555266018L;
    private static final Logger LOG = LoggerFactory.getLogger(SSLCertificateLoader.class);
    private static final String PEER_CERTIFICATES = "PEER_CERTIFICATES";
    private CommonsDataLoader commonsDataLoader;

    public void setCommonsDataLoader(CommonsDataLoader commonsDataLoader) {
        this.commonsDataLoader = commonsDataLoader;
    }

    private CommonsDataLoader getCommonsDataLoader() {
        if (this.commonsDataLoader == null) {
            this.commonsDataLoader = new CommonsDataLoader();
        }
        return this.commonsDataLoader;
    }

    public List<CertificateToken> getCertificates(String urlString) {
        String trimmedUrl = Utils.trim((String)urlString);
        if (Protocol.isHttpUrl((String)trimmedUrl)) {
            Certificate[] httpGetCertificates = this.httpGetCertificates(trimmedUrl);
            return this.toCertificateTokens(httpGetCertificates);
        }
        throw new UnsupportedOperationException(String.format("DSS framework supports only HTTP(S) certificate extraction. Obtained URL : '%s'", urlString));
    }

    private Certificate[] httpGetCertificates(String url) throws DSSException {
        HttpGet httpRequest = null;
        CloseableHttpResponse httpResponse = null;
        CloseableHttpClient client = null;
        try {
            httpRequest = this.getCommonsDataLoader().getHttpRequest(url);
            client = this.getHttpClient(url);
            HttpHost targetHost = this.getCommonsDataLoader().getHttpHost((HttpUriRequest)httpRequest);
            HttpContext localContext = this.getCommonsDataLoader().getHttpContext();
            httpResponse = client.execute(targetHost, (ClassicHttpRequest)httpRequest, localContext);
            Certificate[] certificateArray = this.readCertificates(localContext);
            this.getCommonsDataLoader().closeQuietly((HttpUriRequestBase)httpRequest, httpResponse, client);
            return certificateArray;
        }
        catch (Exception e) {
            try {
                throw new DSSExternalResourceException(String.format("Unable to process GET call for url [%s]. Reason : [%s]", url, DSSUtils.getExceptionMessage((Exception)e)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.getCommonsDataLoader().closeQuietly((HttpUriRequestBase)httpRequest, httpResponse, client);
                throw throwable;
            }
        }
    }

    private List<CertificateToken> toCertificateTokens(Certificate[] certificates) {
        ArrayList<CertificateToken> certificateTokens = new ArrayList<CertificateToken>();
        for (Certificate certificate : certificates) {
            try {
                certificateTokens.add(DSSUtils.loadCertificate((byte[])certificate.getEncoded()));
            }
            catch (CertificateEncodingException e) {
                LOG.warn("Cannot read and/or create an instance of a CertificateToken for a certificate : '{}'. The entry is skipped. Reason : {}", (Object)certificate, (Object)e.getMessage());
            }
        }
        return certificateTokens;
    }

    private Certificate[] readCertificates(HttpContext context) {
        Object attribute = context.getAttribute(PEER_CERTIFICATES);
        if (attribute instanceof Certificate[]) {
            return (Certificate[])attribute;
        }
        return new Certificate[0];
    }

    private synchronized CloseableHttpClient getHttpClient(String url) {
        HttpClientBuilder httpClientBuilder = this.getCommonsDataLoader().getHttpClientBuilder(url);
        httpClientBuilder.addResponseInterceptorLast(this.getHttpResponseInterceptor());
        return httpClientBuilder.build();
    }

    private HttpResponseInterceptor getHttpResponseInterceptor() {
        return new HttpResponseInterceptor(){

            public void process(HttpResponse httpResponse, EntityDetails entityDetails, HttpContext httpContext) throws IOException {
                SSLSession sslSession = (SSLSession)httpContext.getAttribute("http.ssl-session");
                if (sslSession != null) {
                    Certificate[] certificates = sslSession.getPeerCertificates();
                    httpContext.setAttribute(SSLCertificateLoader.PEER_CERTIFICATES, (Object)certificates);
                }
            }
        };
    }
}

