/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.service.ocsp;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.service.NonceSource;
import eu.europa.esig.dss.service.http.commons.OCSPDataLoader;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.client.http.DataLoader;
import eu.europa.esig.dss.spi.exception.DSSExternalResourceException;
import eu.europa.esig.dss.spi.x509.revocation.OnlineRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationSourceAlternateUrlsSupport;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPRespStatus;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPSource;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineOCSPSource
implements OCSPSource,
RevocationSourceAlternateUrlsSupport<OCSP>,
OnlineRevocationSource<OCSP> {
    private static final Logger LOG = LoggerFactory.getLogger(OnlineOCSPSource.class);
    private NonceSource nonceSource;
    private DataLoader dataLoader;
    private DigestAlgorithm certIDDigestAlgorithm = DigestAlgorithm.SHA1;

    public OnlineOCSPSource() {
        this.dataLoader = new OCSPDataLoader();
        LOG.trace("+OnlineOCSPSource with the default data loader.");
    }

    public OnlineOCSPSource(DataLoader dataLoader) {
        this.dataLoader = dataLoader;
        LOG.trace("+OnlineOCSPSource with the specific data loader.");
    }

    public void setDataLoader(DataLoader dataLoader) {
        this.dataLoader = dataLoader;
    }

    public void setNonceSource(NonceSource nonceSource) {
        this.nonceSource = nonceSource;
    }

    public void setCertIDDigestAlgorithm(DigestAlgorithm certIDDigestAlgorithm) {
        Objects.requireNonNull(certIDDigestAlgorithm, "The certIDDigestAlgorithm must not be null!");
        this.certIDDigestAlgorithm = certIDDigestAlgorithm;
    }

    public OCSPToken getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        return this.getRevocationToken(certificateToken, issuerCertificateToken, Collections.emptyList());
    }

    public OCSPToken getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken, List<String> alternativeUrls) {
        List ocspAccessLocations;
        Objects.requireNonNull(this.dataLoader, "DataLoader is not provided !");
        String dssIdAsString = certificateToken.getDSSIdAsString();
        LOG.trace("--> OnlineOCSPSource queried for {}", (Object)dssIdAsString);
        if (Utils.isCollectionNotEmpty(alternativeUrls)) {
            LOG.info("OCSP alternative urls : {}", alternativeUrls);
        }
        if (Utils.isCollectionEmpty((Collection)(ocspAccessLocations = DSSASN1Utils.getOCSPAccessLocations((CertificateToken)certificateToken))) && Utils.isCollectionEmpty(alternativeUrls)) {
            LOG.warn("No OCSP location found for {}", (Object)dssIdAsString);
            return null;
        }
        ocspAccessLocations.addAll(alternativeUrls);
        OnlineRevocationSource.RevocationTokenAndUrl<OCSP> revocationTokenAndUrl = this.getRevocationTokenAndUrl(certificateToken, issuerCertificateToken, ocspAccessLocations);
        if (revocationTokenAndUrl != null) {
            return (OCSPToken)revocationTokenAndUrl.getRevocationToken();
        }
        LOG.debug("No OCSP has been downloaded for a CertificateToken with Id '{}' from a list of urls : {}", (Object)certificateToken.getDSSIdAsString(), (Object)ocspAccessLocations);
        return null;
    }

    public OnlineRevocationSource.RevocationTokenAndUrl<OCSP> getRevocationTokenAndUrl(CertificateToken certificateToken, CertificateToken issuerToken) {
        List ocspAccessLocations = DSSASN1Utils.getOCSPAccessLocations((CertificateToken)certificateToken);
        if (Utils.isCollectionEmpty((Collection)ocspAccessLocations)) {
            LOG.warn("No OCSP location found for {}", (Object)certificateToken.getDSSIdAsString());
            return null;
        }
        return this.getRevocationTokenAndUrl(certificateToken, issuerToken, ocspAccessLocations);
    }

    protected OnlineRevocationSource.RevocationTokenAndUrl<OCSP> getRevocationTokenAndUrl(CertificateToken certificateToken, CertificateToken issuerToken, List<String> ocspUrls) {
        CertificateID certId = DSSRevocationUtils.getOCSPCertificateID((CertificateToken)certificateToken, (CertificateToken)issuerToken, (DigestAlgorithm)this.certIDDigestAlgorithm);
        BigInteger nonce = null;
        if (this.nonceSource != null) {
            nonce = this.nonceSource.getNonce();
        }
        byte[] content = this.buildOCSPRequest(certId, nonce);
        int nbTries = ocspUrls.size();
        for (String ocspAccessLocation : ocspUrls) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Trying to retrieve an OCSP response from URL '{}'...", (Object)ocspAccessLocation);
            }
            --nbTries;
            try {
                byte[] ocspRespBytes = this.dataLoader.post(ocspAccessLocation, content);
                if (!Utils.isArrayEmpty((byte[])ocspRespBytes)) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace(String.format("Obtained OCSPResponse binaries from URL '%s' : %s", ocspAccessLocation, Utils.toBase64((byte[])ocspRespBytes)));
                    }
                    OCSPResp ocspResp = new OCSPResp(ocspRespBytes);
                    this.verifyNonce(ocspResp, nonce);
                    OCSPRespStatus status = OCSPRespStatus.fromInt((int)ocspResp.getStatus());
                    if (OCSPRespStatus.SUCCESSFUL.equals((Object)status)) {
                        BasicOCSPResp basicResponse = (BasicOCSPResp)ocspResp.getResponseObject();
                        SingleResp latestSingleResponse = DSSRevocationUtils.getLatestSingleResponse((BasicOCSPResp)basicResponse, (CertificateToken)certificateToken, (CertificateToken)issuerToken);
                        OCSPToken ocspToken = new OCSPToken(basicResponse, latestSingleResponse, certificateToken, issuerToken);
                        ocspToken.setSourceURL(ocspAccessLocation);
                        ocspToken.setExternalOrigin(RevocationOrigin.EXTERNAL);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("OCSP Response '{}' has been retrieved from a source with URL '{}'.", (Object)ocspToken.getDSSIdAsString(), (Object)ocspAccessLocation);
                        }
                        return new OnlineRevocationSource.RevocationTokenAndUrl(ocspAccessLocation, (RevocationToken)ocspToken);
                    }
                    LOG.warn("Ignored OCSP Response from URL '{}' : status -> {}", (Object)ocspAccessLocation, (Object)status);
                    continue;
                }
                LOG.warn("OCSP Data Loader for certificate {} responded with an empty byte array!", (Object)certificateToken.getDSSIdAsString());
            }
            catch (Exception e) {
                if (nbTries == 0) {
                    throw new DSSExternalResourceException(String.format("Unable to retrieve OCSP response for certificate with Id '%s' from URL '%s'. Reason : %s", certificateToken.getDSSIdAsString(), ocspAccessLocation, e.getMessage()), (Throwable)e);
                }
                LOG.warn("Unable to retrieve OCSP response with URL '{}' : {}", (Object)ocspAccessLocation, (Object)e.getMessage());
            }
        }
        return null;
    }

    private byte[] buildOCSPRequest(CertificateID certId, BigInteger nonce) throws DSSException {
        try {
            OCSPReqBuilder ocspReqBuilder = new OCSPReqBuilder();
            ocspReqBuilder.addRequest(certId);
            if (nonce != null) {
                DEROctetString encodedNonceValue = new DEROctetString(new DEROctetString(nonce.toByteArray()).getEncoded());
                Extension extension = new Extension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, false, (ASN1OctetString)encodedNonceValue);
                Extensions extensions = new Extensions(extension);
                ocspReqBuilder.setRequestExtensions(extensions);
            }
            OCSPReq ocspReq = ocspReqBuilder.build();
            return ocspReq.getEncoded();
        }
        catch (IOException | OCSPException e) {
            throw new DSSException("Cannot build OCSP Request", e);
        }
    }

    private void verifyNonce(OCSPResp ocspResp, BigInteger expectedNonceValue) {
        BigInteger receivedNonce;
        if (expectedNonceValue != null && !expectedNonceValue.equals(receivedNonce = this.getEmbeddedNonceValue(ocspResp))) {
            throw new DSSExternalResourceException(String.format("Nonce received from OCSP response '%s' does not match a dispatched nonce '%s'.", receivedNonce, expectedNonceValue));
        }
    }

    private BigInteger getEmbeddedNonceValue(OCSPResp ocspResp) {
        try {
            BasicOCSPResp basicOCSPResp = (BasicOCSPResp)ocspResp.getResponseObject();
            Extension extension = basicOCSPResp.getExtension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce);
            ASN1OctetString extnValue = extension.getExtnValue();
            ASN1Primitive value = this.fromByteArray(extnValue);
            if (value instanceof DEROctetString) {
                return new BigInteger(((DEROctetString)value).getOctets());
            }
            throw new OCSPException("Nonce extension value in OCSP response is not an OCTET STRING");
        }
        catch (Exception e) {
            throw new DSSExternalResourceException(String.format("Unable to extract the nonce from the OCSPResponse! Reason : [%s]", e.getMessage()), (Throwable)e);
        }
    }

    private ASN1Primitive fromByteArray(ASN1OctetString extnValue) throws OCSPException {
        try {
            return ASN1Primitive.fromByteArray((byte[])extnValue.getOctets());
        }
        catch (IOException ex) {
            throw new OCSPException("Invalid encoding of nonce extension value in OCSP response", (Throwable)ex);
        }
    }
}

