/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.client.crl;

import eu.europa.esig.dss.DSSASN1Utils;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.client.http.DataLoader;
import eu.europa.esig.dss.client.http.Protocol;
import eu.europa.esig.dss.client.http.commons.CommonsDataLoader;
import eu.europa.esig.dss.crl.CRLUtils;
import eu.europa.esig.dss.crl.CRLValidity;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.crl.CRLSource;
import eu.europa.esig.dss.x509.crl.CRLToken;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineCRLSource
implements CRLSource {
    private static final Logger LOG = LoggerFactory.getLogger(OnlineCRLSource.class);
    private Protocol preferredProtocol;
    private DataLoader dataLoader;

    public OnlineCRLSource() {
        this.dataLoader = new CommonsDataLoader();
        LOG.trace("+OnlineCRLSource with the default data loader.");
    }

    public OnlineCRLSource(DataLoader dataLoader) {
        this.dataLoader = dataLoader;
        LOG.trace("+OnlineCRLSource with the specific data loader.");
    }

    public void setPreferredProtocol(Protocol preferredProtocol) {
        this.preferredProtocol = preferredProtocol;
    }

    public void setDataLoader(DataLoader dataLoader) {
        this.dataLoader = dataLoader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CRLToken findCrl(CertificateToken certificateToken) throws DSSException {
        if (certificateToken == null) {
            return null;
        }
        CertificateToken issuerToken = certificateToken.getIssuerToken();
        if (issuerToken == null) {
            return null;
        }
        List crlUrls = DSSASN1Utils.getCrlUrls((CertificateToken)certificateToken);
        LOG.info("CRL's URL for " + certificateToken.getAbbreviation() + " : " + crlUrls);
        if (Utils.isCollectionEmpty((Collection)crlUrls)) {
            return null;
        }
        this.prioritize(crlUrls);
        DataLoader.DataAndUrl dataAndUrl = this.downloadCrl(crlUrls);
        if (dataAndUrl == null) {
            return null;
        }
        try (ByteArrayInputStream bais = new ByteArrayInputStream(dataAndUrl.data);){
            CRLValidity crlValidity = CRLUtils.isValidCRL((InputStream)bais, (CertificateToken)issuerToken);
            CRLToken crlToken = new CRLToken(certificateToken, crlValidity);
            crlToken.setSourceURL(dataAndUrl.urlString);
            crlToken.setAvailable(true);
            CRLToken cRLToken = crlToken;
            return cRLToken;
        }
        catch (Exception e) {
            LOG.warn("Unable to parse/validate the CRL (url:" + dataAndUrl.urlString + ") : " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private DataLoader.DataAndUrl downloadCrl(List<String> downloadUrls) {
        try {
            return this.dataLoader.get(downloadUrls);
        }
        catch (DSSException e) {
            LOG.warn("Unable to download CRL from URLs {}", downloadUrls, (Object)e);
            return null;
        }
    }

    private void prioritize(List<String> urls) {
        if (this.preferredProtocol != null) {
            ArrayList<String> priorityUrls = new ArrayList<String>();
            for (String url : urls) {
                if (!this.preferredProtocol.isTheSame(url)) continue;
                priorityUrls.add(url);
            }
            urls.removeAll(priorityUrls);
            for (int ii = priorityUrls.size() - 1; ii >= 0; --ii) {
                urls.add(0, (String)priorityUrls.get(ii));
            }
        }
    }
}

