/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.client.http.commons;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;

public final class DefaultKeyManager
implements X509KeyManager {
    private X509KeyManager keyManager;

    public DefaultKeyManager(KeyStore keystore, String ksPasswd) throws GeneralSecurityException, IOException {
        this.initKeyManager(keystore, ksPasswd);
    }

    public DefaultKeyManager(InputStream ksInputStream, String keyStoreType, String ksPasswd) throws GeneralSecurityException, IOException {
        KeyStore keystore = KeyStore.getInstance(keyStoreType);
        keystore.load(ksInputStream, ksPasswd.toCharArray());
        this.initKeyManager(keystore, ksPasswd);
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        return this.keyManager.chooseClientAlias(keyType, issuers, socket);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this.keyManager.chooseServerAlias(keyType, issuers, socket);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        return this.keyManager.getCertificateChain(alias);
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.keyManager.getClientAliases(keyType, issuers);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this.keyManager.getPrivateKey(alias);
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.keyManager.getServerAliases(keyType, issuers);
    }

    private void initKeyManager(KeyStore keystore, String ksPasswd) throws GeneralSecurityException {
        KeyManager[] kms;
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(keystore, ksPasswd.toCharArray());
        for (KeyManager km : kms = kmf.getKeyManagers()) {
            if (!(km instanceof X509KeyManager)) continue;
            this.keyManager = (X509KeyManager)km;
            return;
        }
        throw new NoSuchAlgorithmException("No X509KeyManager in KeyManagerFactory");
    }
}

