/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.service.http.commons;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.service.http.commons.LdapURLUtils;
import eu.europa.esig.dss.service.http.proxy.ProxyConfig;
import eu.europa.esig.dss.service.http.proxy.ProxyProperties;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.client.http.DataLoader;
import eu.europa.esig.dss.spi.client.http.Protocol;
import eu.europa.esig.dss.spi.exception.DSSDataLoaderMultipleException;
import eu.europa.esig.dss.spi.exception.DSSExternalResourceException;
import eu.europa.esig.dss.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonsDataLoader
implements DataLoader {
    private static final long serialVersionUID = -805432648564425522L;
    private static final Logger LOG = LoggerFactory.getLogger(CommonsDataLoader.class);
    private static final int TIMEOUT_CONNECTION = 6000;
    private static final int TIMEOUT_SOCKET = 6000;
    private static final int CONNECTIONS_MAX_TOTAL = 20;
    private static final int CONNECTIONS_MAX_PER_ROUTE = 2;
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String DEFAULT_SSL_PROTOCOL = "TLSv1.2";
    private static final List<Integer> ACCEPTED_HTTP_STATUS = Arrays.asList(200);
    protected String contentType;
    private ProxyConfig proxyConfig;
    private int timeoutConnection = 6000;
    private int timeoutSocket = 6000;
    private int connectionsMaxTotal = 20;
    private int connectionsMaxPerRoute = 2;
    private boolean redirectsEnabled = true;
    private List<Integer> acceptedHttpStatus = ACCEPTED_HTTP_STATUS;
    private final Map<HttpHost, UsernamePasswordCredentials> authenticationMap = new HashMap<HttpHost, UsernamePasswordCredentials>();
    private String sslProtocol = "TLSv1.2";
    private DSSDocument sslKeystore;
    private String sslKeystoreType = KeyStore.getDefaultType();
    private String sslKeystorePassword = "";
    private boolean loadKeyStoreAsTrustMaterial = false;
    private DSSDocument sslTruststore;
    private String sslTruststoreType = KeyStore.getDefaultType();
    private String sslTruststorePassword = "";
    private TrustStrategy trustStrategy;
    private String[] supportedSSLProtocols;
    private String[] supportedSSLCipherSuites;
    private HostnameVerifier hostnameVerifier = SSLConnectionSocketFactory.getDefaultHostnameVerifier();
    private HttpRequestRetryHandler retryHandler;
    private ServiceUnavailableRetryStrategy serviceUnavailableRetryStrategy;

    public CommonsDataLoader() {
        this(null);
    }

    public CommonsDataLoader(String contentType) {
        this.contentType = contentType;
    }

    private HttpClientConnectionManager getConnectionManager() {
        RegistryBuilder<ConnectionSocketFactory> socketFactoryRegistryBuilder = RegistryBuilder.create();
        socketFactoryRegistryBuilder = this.setConnectionManagerSchemeHttp(socketFactoryRegistryBuilder);
        socketFactoryRegistryBuilder = this.setConnectionManagerSchemeHttps(socketFactoryRegistryBuilder);
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistryBuilder.build());
        connectionManager.setMaxTotal(this.getConnectionsMaxTotal());
        connectionManager.setDefaultMaxPerRoute(this.getConnectionsMaxPerRoute());
        LOG.debug("PoolingHttpClientConnectionManager: max total: {}", (Object)connectionManager.getMaxTotal());
        LOG.debug("PoolingHttpClientConnectionManager: max per route: {}", (Object)connectionManager.getDefaultMaxPerRoute());
        return connectionManager;
    }

    private RegistryBuilder<ConnectionSocketFactory> setConnectionManagerSchemeHttp(RegistryBuilder<ConnectionSocketFactory> socketFactoryRegistryBuilder) {
        return socketFactoryRegistryBuilder.register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
    }

    private RegistryBuilder<ConnectionSocketFactory> setConnectionManagerSchemeHttps(RegistryBuilder<ConnectionSocketFactory> socketFactoryRegistryBuilder) {
        try {
            KeyStore sslKeystore;
            KeyStore sslTrustStore;
            SSLContextBuilder sslContextBuilder = SSLContextBuilder.create();
            sslContextBuilder.setProtocol(this.sslProtocol);
            TrustStrategy trustStrategy = this.getTrustStrategy();
            if (trustStrategy != null) {
                LOG.debug("Set the TrustStrategy");
                sslContextBuilder.loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)trustStrategy);
            }
            if ((sslTrustStore = this.getSSLTrustStore()) != null) {
                LOG.debug("Set the SSL trust store as trust materials");
                sslContextBuilder.loadTrustMaterial(sslTrustStore, (org.apache.http.ssl.TrustStrategy)trustStrategy);
            }
            if ((sslKeystore = this.getSSLKeyStore()) != null) {
                LOG.debug("Set the SSL keystore as key materials");
                char[] password = this.sslKeystorePassword != null ? this.sslKeystorePassword.toCharArray() : null;
                sslContextBuilder.loadKeyMaterial(sslKeystore, password);
                if (this.loadKeyStoreAsTrustMaterial) {
                    LOG.debug("Set the SSL keystore as trust materials");
                    sslContextBuilder.loadTrustMaterial(sslKeystore, (org.apache.http.ssl.TrustStrategy)trustStrategy);
                }
            }
            SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContextBuilder.build(), this.getSupportedSSLProtocols(), this.getSupportedSSLCipherSuites(), this.getHostnameVerifier());
            return socketFactoryRegistryBuilder.register("https", (Object)sslConnectionSocketFactory);
        }
        catch (Exception e) {
            throw new DSSException("Unable to configure the SSLContext/SSLConnectionSocketFactory", (Throwable)e);
        }
    }

    protected KeyStore getSSLKeyStore() throws IOException, GeneralSecurityException {
        return this.loadKeyStore(this.sslKeystore, this.sslKeystoreType, this.sslKeystorePassword);
    }

    protected KeyStore getSSLTrustStore() throws IOException, GeneralSecurityException {
        return this.loadKeyStore(this.sslTruststore, this.sslTruststoreType, this.sslTruststorePassword);
    }

    private KeyStore loadKeyStore(DSSDocument store, String type, String passwordStr) throws IOException, GeneralSecurityException {
        if (store != null) {
            try (InputStream is = store.openStream();){
                KeyStore ks = KeyStore.getInstance(type);
                char[] password = passwordStr != null ? passwordStr.toCharArray() : null;
                ks.load(is, password);
                KeyStore keyStore = ks;
                return keyStore;
            }
        }
        return null;
    }

    protected synchronized HttpGet getHttpRequest(String url) throws URISyntaxException {
        URI uri = new URI(url.trim());
        HttpGet httpRequest = new HttpGet(uri);
        if (this.contentType != null) {
            httpRequest.setHeader(CONTENT_TYPE, this.contentType);
        }
        return httpRequest;
    }

    protected synchronized HttpClientBuilder getHttpClientBuilder(String url) {
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        httpClientBuilder = this.configCredentials(httpClientBuilder, url);
        RequestConfig.Builder custom = RequestConfig.custom();
        custom.setSocketTimeout(this.timeoutSocket);
        custom.setConnectTimeout(this.timeoutConnection);
        custom.setRedirectsEnabled(this.redirectsEnabled);
        custom.setCookieSpec("standard");
        RequestConfig requestConfig = custom.build();
        httpClientBuilder = httpClientBuilder.setDefaultRequestConfig(requestConfig);
        httpClientBuilder.setConnectionManager(this.getConnectionManager());
        httpClientBuilder.setRetryHandler(this.retryHandler);
        httpClientBuilder.setServiceUnavailableRetryStrategy(this.serviceUnavailableRetryStrategy);
        return httpClientBuilder;
    }

    protected synchronized CloseableHttpClient getHttpClient(String url) {
        return this.getHttpClientBuilder(url).build();
    }

    private HttpClientBuilder configCredentials(HttpClientBuilder httpClientBuilder, String url) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        for (Map.Entry<HttpHost, UsernamePasswordCredentials> entry : this.authenticationMap.entrySet()) {
            HttpHost httpHost = entry.getKey();
            UsernamePasswordCredentials usernamePasswordCredentials = entry.getValue();
            AuthScope authscope = new AuthScope(httpHost.getHostName(), httpHost.getPort());
            credentialsProvider.setCredentials(authscope, (Credentials)usernamePasswordCredentials);
        }
        httpClientBuilder = httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        httpClientBuilder = this.configureProxy(httpClientBuilder, (CredentialsProvider)credentialsProvider, url);
        return httpClientBuilder;
    }

    private HttpClientBuilder configureProxy(HttpClientBuilder httpClientBuilder, CredentialsProvider credentialsProvider, String url) {
        if (this.proxyConfig == null) {
            return httpClientBuilder;
        }
        String protocol = this.getURL(url).getProtocol();
        boolean proxyHTTPS = Protocol.isHttps((String)protocol) && this.proxyConfig.getHttpsProperties() != null;
        boolean proxyHTTP = Protocol.isHttp((String)protocol) && this.proxyConfig.getHttpProperties() != null;
        ProxyProperties proxyProps = null;
        if (proxyHTTPS) {
            LOG.debug("Use proxy https parameters");
            proxyProps = this.proxyConfig.getHttpsProperties();
        } else if (proxyHTTP) {
            LOG.debug("Use proxy http parameters");
            proxyProps = this.proxyConfig.getHttpProperties();
        } else {
            return httpClientBuilder;
        }
        String proxyHost = proxyProps.getHost();
        int proxyPort = proxyProps.getPort();
        String proxyUser = proxyProps.getUser();
        String proxyPassword = proxyProps.getPassword();
        String proxyExcludedHosts = proxyProps.getExcludedHosts();
        if (Utils.isStringNotEmpty((String)proxyUser) && Utils.isStringNotEmpty((String)proxyPassword)) {
            AuthScope proxyAuth = new AuthScope(proxyHost, proxyPort);
            UsernamePasswordCredentials proxyCredentials = new UsernamePasswordCredentials(proxyUser, proxyPassword);
            credentialsProvider.setCredentials(proxyAuth, (Credentials)proxyCredentials);
        }
        LOG.debug("proxy host/port: {}:{}", (Object)proxyHost, (Object)proxyPort);
        HttpHost proxy = new HttpHost(proxyHost, proxyPort, Protocol.HTTP.getName());
        if (Utils.isStringNotEmpty((String)proxyExcludedHosts)) {
            final String[] hosts = proxyExcludedHosts.split("[,; ]");
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy){

                public HttpRoute determineRoute(HttpHost host, HttpRequest request, HttpContext context) throws HttpException {
                    String hostname;
                    String string = hostname = host != null ? host.getHostName() : null;
                    if (hosts != null && hostname != null) {
                        for (String h : hosts) {
                            if (!hostname.equalsIgnoreCase(h)) continue;
                            return new HttpRoute(host);
                        }
                    }
                    return super.determineRoute(host, request, context);
                }
            };
            httpClientBuilder.setRoutePlanner((HttpRoutePlanner)routePlanner);
        }
        return httpClientBuilder.setProxy(proxy);
    }

    public byte[] get(String urlString) throws DSSException {
        if (Protocol.isFileUrl((String)urlString)) {
            return this.fileGet(urlString);
        }
        if (Protocol.isHttpUrl((String)urlString)) {
            return this.httpGet(urlString);
        }
        if (Protocol.isFtpUrl((String)urlString)) {
            return this.ftpGet(urlString);
        }
        if (Protocol.isLdapUrl((String)urlString)) {
            return this.ldapGet(urlString);
        }
        LOG.warn("DSS framework only supports FILE, HTTP, HTTPS, FTP and LDAP Urls.");
        return this.httpGet(urlString);
    }

    public DataLoader.DataAndUrl get(List<String> urlStrings) throws DSSException {
        if (Utils.isCollectionEmpty(urlStrings)) {
            throw new DSSException("Cannot process the GET call. List of URLs is empty!");
        }
        HashMap<String, Exception> exceptions = new HashMap<String, Exception>();
        for (String urlString : urlStrings) {
            LOG.debug("Processing a GET call to URL [{}]...", (Object)urlString);
            try {
                byte[] bytes = this.get(urlString);
                if (Utils.isArrayEmpty((byte[])bytes)) {
                    LOG.debug("The retrieved content from URL [{}] is empty. Continue with other URLs...", (Object)urlString);
                    continue;
                }
                return new DataLoader.DataAndUrl(bytes, urlString);
            }
            catch (Exception e) {
                LOG.warn("Cannot obtain data using '{}' : {}", (Object)urlString, (Object)e.getMessage());
                exceptions.put(urlString, e);
            }
        }
        throw new DSSDataLoaderMultipleException(exceptions);
    }

    public byte[] get(String url, boolean refresh) throws DSSException {
        return this.get(url);
    }

    protected byte[] ldapGet(String urlString) throws DSSException {
        urlString = LdapURLUtils.encode(urlString);
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", urlString);
        try {
            InitialDirContext ctx;
            Attributes attributes;
            String attributeName;
            String ldapParams = Utils.substringAfter((String)urlString, (String)"?");
            StringTokenizer tokenizer = new StringTokenizer(ldapParams, "?");
            String string = attributeName = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : null;
            if (Utils.isStringEmpty((String)attributeName)) {
                attributeName = "certificateRevocationList;binary";
            }
            if ((attributes = (ctx = new InitialDirContext(env)).getAttributes("", new String[]{attributeName})) == null || attributes.size() < 1) {
                throw new DSSException(String.format("Cannot download binaries from: [%s], no attributes with name: [%s] returned", urlString, attributeName));
            }
            Attribute attribute = attributes.getAll().next();
            byte[] ldapBytes = (byte[])attribute.get();
            if (Utils.isArrayNotEmpty((byte[])ldapBytes)) {
                return ldapBytes;
            }
            throw new DSSException(String.format("The retrieved ldap content from url [%s] is empty", urlString));
        }
        catch (DSSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DSSExternalResourceException(String.format("Cannot get data from URL [%s]. Reason : [%s]", urlString, e.getMessage()), (Throwable)e);
        }
    }

    protected byte[] ftpGet(String urlString) throws DSSException {
        byte[] byArray;
        block8: {
            URL url = this.getURL(urlString);
            InputStream inputStream = url.openStream();
            try {
                byArray = DSSUtils.toByteArray((InputStream)inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new DSSExternalResourceException(String.format("Unable to retrieve file from URL %s. Reason : [%s]", urlString, e.getMessage()), (Throwable)e);
                }
            }
            inputStream.close();
        }
        return byArray;
    }

    protected byte[] fileGet(String urlString) throws DSSException {
        return this.ftpGet(urlString);
    }

    private URL getURL(String urlString) {
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new DSSException("Unable to create URL instance", (Throwable)e);
        }
    }

    protected byte[] httpGet(String url) throws DSSException {
        HttpGet httpRequest = null;
        CloseableHttpResponse httpResponse = null;
        CloseableHttpClient client = null;
        try {
            httpRequest = this.getHttpRequest(url);
            client = this.getHttpClient(url);
            httpResponse = this.getHttpResponse(client, (HttpUriRequest)httpRequest);
            byte[] byArray = this.readHttpResponse(httpResponse);
            this.closeQuietly((HttpRequestBase)httpRequest, httpResponse, client);
            return byArray;
        }
        catch (IOException | URISyntaxException e) {
            try {
                throw new DSSExternalResourceException(String.format("Unable to process GET call for url [%s]. Reason : [%s]", url, DSSUtils.getExceptionMessage((Exception)e)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.closeQuietly((HttpRequestBase)httpRequest, httpResponse, client);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeQuietly(HttpRequestBase httpRequest, CloseableHttpResponse httpResponse, CloseableHttpClient client) {
        try {
            if (httpRequest != null) {
                httpRequest.releaseConnection();
            }
            if (httpResponse != null) {
                EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
                Utils.closeQuietly((Closeable)httpResponse);
            }
        }
        finally {
            Utils.closeQuietly((Closeable)client);
        }
    }

    public byte[] post(String url, byte[] content) {
        LOG.debug("Fetching data via POST from url {}", (Object)url);
        HttpPost httpRequest = null;
        CloseableHttpResponse httpResponse = null;
        CloseableHttpClient client = null;
        try {
            URI uri = URI.create(url.trim());
            httpRequest = new HttpPost(uri);
            ByteArrayInputStream bis = new ByteArrayInputStream(content);
            InputStreamEntity httpEntity = new InputStreamEntity((InputStream)bis, (long)content.length);
            BufferedHttpEntity requestEntity = new BufferedHttpEntity((HttpEntity)httpEntity);
            httpRequest.setEntity((HttpEntity)requestEntity);
            if (this.contentType != null) {
                httpRequest.setHeader(CONTENT_TYPE, this.contentType);
            }
            client = this.getHttpClient(url);
            httpResponse = this.getHttpResponse(client, (HttpUriRequest)httpRequest);
            byte[] byArray = this.readHttpResponse(httpResponse);
            this.closeQuietly((HttpRequestBase)httpRequest, httpResponse, client);
            return byArray;
        }
        catch (IOException e) {
            try {
                throw new DSSExternalResourceException(String.format("Unable to process POST call for url [%s]. Reason : [%s]", url, e.getMessage()), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.closeQuietly((HttpRequestBase)httpRequest, httpResponse, client);
                throw throwable;
            }
        }
    }

    protected CloseableHttpResponse getHttpResponse(CloseableHttpClient client, HttpUriRequest httpRequest) throws IOException {
        HttpHost targetHost = this.getHttpHost(httpRequest);
        HttpContext localContext = this.getHttpContext(targetHost);
        return client.execute(targetHost, (HttpRequest)httpRequest, localContext);
    }

    protected HttpHost getHttpHost(HttpUriRequest httpRequest) {
        URI uri = httpRequest.getURI();
        return new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
    }

    protected HttpContext getHttpContext(HttpHost targetHost) {
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(targetHost, (AuthScheme)basicAuth);
        HttpClientContext localContext = HttpClientContext.create();
        localContext.setAuthCache((AuthCache)authCache);
        return localContext;
    }

    protected byte[] readHttpResponse(CloseableHttpResponse httpResponse) throws IOException {
        StatusLine statusLine = httpResponse.getStatusLine();
        int statusCode = statusLine.getStatusCode();
        String reasonPhrase = statusLine.getReasonPhrase();
        if (!this.acceptedHttpStatus.contains(statusCode)) {
            String reason = Utils.isStringNotEmpty((String)reasonPhrase) ? " / reason : " + reasonPhrase : "";
            throw new IOException("Not acceptable HTTP Status (HTTP status code : " + statusCode + reason + ")");
        }
        HttpEntity responseEntity = httpResponse.getEntity();
        if (responseEntity == null) {
            throw new IOException("No message entity for this response");
        }
        return this.getContent(responseEntity);
    }

    protected byte[] getContent(HttpEntity responseEntity) throws IOException {
        try (InputStream content = responseEntity.getContent();){
            byte[] byArray = DSSUtils.toByteArray((InputStream)content);
            return byArray;
        }
    }

    public int getTimeoutConnection() {
        return this.timeoutConnection;
    }

    public void setTimeoutConnection(int timeoutConnection) {
        this.timeoutConnection = timeoutConnection;
    }

    public int getTimeoutSocket() {
        return this.timeoutSocket;
    }

    public void setTimeoutSocket(int timeoutSocket) {
        this.timeoutSocket = timeoutSocket;
    }

    public int getConnectionsMaxTotal() {
        return this.connectionsMaxTotal;
    }

    public void setConnectionsMaxTotal(int connectionsMaxTotal) {
        this.connectionsMaxTotal = connectionsMaxTotal;
    }

    public int getConnectionsMaxPerRoute() {
        return this.connectionsMaxPerRoute;
    }

    public void setConnectionsMaxPerRoute(int connectionsMaxPerRoute) {
        this.connectionsMaxPerRoute = connectionsMaxPerRoute;
    }

    public boolean isRedirectsEnabled() {
        return this.redirectsEnabled;
    }

    public void setRedirectsEnabled(boolean redirectsEnabled) {
        this.redirectsEnabled = redirectsEnabled;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public List<Integer> getAcceptedHttpStatus() {
        return this.acceptedHttpStatus;
    }

    public void setAcceptedHttpStatus(List<Integer> acceptedHttpStatus) {
        this.acceptedHttpStatus = acceptedHttpStatus;
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public void setProxyConfig(ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
    }

    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public void setSslKeystore(DSSDocument sslKeyStore) {
        this.sslKeystore = sslKeyStore;
    }

    public void setKeyStoreAsTrustMaterial(boolean loadKeyStoreAsTrustMaterial) {
        this.loadKeyStoreAsTrustMaterial = loadKeyStoreAsTrustMaterial;
    }

    public void setSslKeystoreType(String sslKeystoreType) {
        this.sslKeystoreType = sslKeystoreType;
    }

    public void setSslKeystorePassword(String sslKeystorePassword) {
        this.sslKeystorePassword = sslKeystorePassword;
    }

    public void setSslTruststore(DSSDocument sslTrustStore) {
        this.sslTruststore = sslTrustStore;
    }

    public void setSslTruststorePassword(String sslTruststorePassword) {
        this.sslTruststorePassword = sslTruststorePassword;
    }

    public void setSslTruststoreType(String sslTruststoreType) {
        this.sslTruststoreType = sslTruststoreType;
    }

    public CommonsDataLoader addAuthentication(String host, int port, String scheme, String login, String password) {
        HttpHost httpHost = new HttpHost(host, port, scheme);
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(login, password);
        this.authenticationMap.put(httpHost, credentials);
        return this;
    }

    public void propagateAuthentication(CommonsDataLoader commonsDataLoader) {
        for (Map.Entry<HttpHost, UsernamePasswordCredentials> credentialsEntry : this.authenticationMap.entrySet()) {
            HttpHost httpHost = credentialsEntry.getKey();
            UsernamePasswordCredentials credentials = credentialsEntry.getValue();
            commonsDataLoader.addAuthentication(httpHost.getHostName(), httpHost.getPort(), httpHost.getSchemeName(), credentials.getUserName(), credentials.getPassword());
        }
    }

    public void setRetryHandler(HttpRequestRetryHandler retryHandler) {
        this.retryHandler = retryHandler;
    }

    public void setServiceUnavailableRetryStrategy(ServiceUnavailableRetryStrategy serviceUnavailableRetryStrategy) {
        this.serviceUnavailableRetryStrategy = serviceUnavailableRetryStrategy;
    }

    public String[] getSupportedSSLProtocols() {
        return this.supportedSSLProtocols;
    }

    public void setSupportedSSLProtocols(String[] supportedSSLProtocols) {
        this.supportedSSLProtocols = supportedSSLProtocols;
    }

    public String[] getSupportedSSLCipherSuites() {
        return this.supportedSSLCipherSuites;
    }

    public void setSupportedSSLCipherSuites(String[] supportedSSLCipherSuites) {
        this.supportedSSLCipherSuites = supportedSSLCipherSuites;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public TrustStrategy getTrustStrategy() {
        return this.trustStrategy;
    }

    public void setTrustStrategy(TrustStrategy trustStrategy) {
        this.trustStrategy = trustStrategy;
    }
}

