/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.service.tsp;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.TimestampBinary;
import eu.europa.esig.dss.service.NonceSource;
import eu.europa.esig.dss.service.http.commons.TimestampDataLoader;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.client.http.DataLoader;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cmp.PKIFailureInfo;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineTSPSource
implements TSPSource {
    private static final long serialVersionUID = 2327302822894625162L;
    private static final Logger LOG = LoggerFactory.getLogger(OnlineTSPSource.class);
    private String tspServer;
    private ASN1ObjectIdentifier policyOid;
    private DataLoader dataLoader;
    private NonceSource nonceSource;

    public OnlineTSPSource() {
        this(null);
    }

    public OnlineTSPSource(String tspServer) {
        this.tspServer = tspServer;
        this.dataLoader = new TimestampDataLoader();
        LOG.trace("+OnlineTSPSource with the default data loader.");
    }

    public OnlineTSPSource(String tspServer, DataLoader dataLoader) {
        this.tspServer = tspServer;
        this.dataLoader = dataLoader;
        LOG.trace("+OnlineTSPSource with the specific data loader.");
    }

    public void setTspServer(String tspServer) {
        this.tspServer = tspServer;
    }

    public void setPolicyOid(String policyOid) {
        this.policyOid = new ASN1ObjectIdentifier(policyOid);
    }

    public void setDataLoader(DataLoader dataLoader) {
        this.dataLoader = dataLoader;
    }

    public void setNonceSource(NonceSource nonceSource) {
        this.nonceSource = nonceSource;
    }

    public TimestampBinary getTimeStampResponse(DigestAlgorithm digestAlgorithm, byte[] digest) throws DSSException {
        try {
            TimeStampToken timeStampToken;
            PKIFailureInfo failInfo;
            Objects.requireNonNull(this.dataLoader, "DataLoader is not provided !");
            if (LOG.isTraceEnabled()) {
                LOG.trace("Timestamp digest algorithm: {}", (Object)digestAlgorithm.getName());
                LOG.trace("Timestamp digest value    : {}", (Object)Utils.toHex((byte[])digest));
            }
            TimeStampRequestGenerator tsqGenerator = new TimeStampRequestGenerator();
            tsqGenerator.setCertReq(true);
            if (this.policyOid != null) {
                tsqGenerator.setReqPolicy(this.policyOid);
            }
            ASN1ObjectIdentifier asn1ObjectIdentifier = new ASN1ObjectIdentifier(digestAlgorithm.getOid());
            TimeStampRequest timeStampRequest = null;
            timeStampRequest = this.nonceSource == null ? tsqGenerator.generate(asn1ObjectIdentifier, digest) : tsqGenerator.generate(asn1ObjectIdentifier, digest, this.nonceSource.getNonce());
            byte[] requestBytes = timeStampRequest.getEncoded();
            byte[] respBytes = this.dataLoader.post(this.tspServer, requestBytes);
            TimeStampResponse timeStampResponse = new TimeStampResponse(respBytes);
            timeStampResponse.validate(timeStampRequest);
            String statusString = timeStampResponse.getStatusString();
            if (statusString != null) {
                LOG.info("TSP Status: {}", (Object)statusString);
            }
            if ((failInfo = timeStampResponse.getFailInfo()) != null) {
                LOG.warn("TSP Failure info: {}", (Object)failInfo);
            }
            if ((timeStampToken = timeStampResponse.getTimeStampToken()) == null) {
                throw new DSSException("No retrieved timestamp token (TSP Status : " + statusString + " / " + failInfo + ")");
            }
            LOG.info("TSP SID : SN {}, Issuer {}", (Object)timeStampToken.getSID().getSerialNumber(), (Object)timeStampToken.getSID().getIssuer());
            return new TimestampBinary(DSSASN1Utils.getDEREncoded((TimeStampToken)timeStampToken));
        }
        catch (TSPException e) {
            throw new DSSException("Invalid TSP response", (Throwable)e);
        }
        catch (IOException e) {
            throw new DSSException((Throwable)e);
        }
    }
}

