/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.service.http.commons;

import eu.europa.esig.dss.model.DSSException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;

public class ResourceLoader {
    protected Class<?> anyClass = ResourceLoader.class;

    public ResourceLoader() {
    }

    public ResourceLoader(Class<?> anyClass) {
        this.anyClass = anyClass;
    }

    public String getAbsoluteResourceFolder(String resourcePath) throws DSSException {
        URL uri = this.anyClass.getResource(resourcePath);
        if (uri == null) {
            return null;
        }
        String absolutePath = uri.getPath();
        try {
            String decodedAbsolutePath = URLDecoder.decode(absolutePath, "UTF-8");
            return decodedAbsolutePath;
        }
        catch (UnsupportedEncodingException e) {
            throw new DSSException(String.format("Unable to decode URI path : %s", e.getMessage()), (Throwable)e);
        }
    }
}

