/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.service.x509.aia;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.client.jdbc.JdbcCacheConnector;
import eu.europa.esig.dss.spi.client.jdbc.query.SqlQuery;
import eu.europa.esig.dss.spi.client.jdbc.query.SqlSelectQuery;
import eu.europa.esig.dss.spi.client.jdbc.record.SqlRecord;
import eu.europa.esig.dss.spi.exception.DSSExternalResourceException;
import eu.europa.esig.dss.spi.x509.aia.RepositoryAIASource;
import eu.europa.esig.dss.utils.Utils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcCacheAIASource
extends RepositoryAIASource {
    private static final long serialVersionUID = -4332455769204417938L;
    private static final Logger LOG = LoggerFactory.getLogger(JdbcCacheAIASource.class);
    private static final SqlQuery SQL_INIT_CHECK_EXISTENCE = SqlQuery.createQuery((String)"SELECT COUNT(*) FROM AIA_CERTIFICATES");
    private static final SqlQuery SQL_INIT_CREATE_TABLE = SqlQuery.createQuery((String)"CREATE TABLE AIA_CERTIFICATES (ID CHAR(40), AIA CHAR(40), DATA BLOB)");
    private static final SqlQuery SQL_DROP_TABLE = SqlQuery.createQuery((String)"DROP TABLE AIA_CERTIFICATES");
    private static final SqlQuery SQL_FIND_INSERT = SqlQuery.createQuery((String)"INSERT INTO AIA_CERTIFICATES (ID, AIA, DATA) VALUES (?, ?, ?)");
    private static final SqlQuery SQL_FIND_REMOVE = SqlQuery.createQuery((String)"DELETE FROM AIA_CERTIFICATES WHERE AIA = ?");
    private static final SqlSelectQuery SQL_FIND_QUERY = new SqlSelectQuery("SELECT * FROM AIA_CERTIFICATES WHERE AIA = ?"){

        public SqlAIAResponse getRecord(ResultSet rs) throws SQLException {
            SqlAIAResponse response = new SqlAIAResponse();
            response.id = rs.getString("ID");
            response.aiaKey = rs.getString("AIA");
            response.certificateBinary = rs.getBytes("DATA");
            return response;
        }
    };
    private static final SqlSelectQuery SQL_DISTINCT_AIA_KEYS_QUERY = new SqlSelectQuery("SELECT DISTINCT AIA FROM AIA_CERTIFICATES"){

        public SqlAIAResponse getRecord(ResultSet rs) throws SQLException {
            SqlAIAResponse response = new SqlAIAResponse();
            response.aiaKey = rs.getString("AIA");
            return response;
        }
    };
    protected transient JdbcCacheConnector jdbcCacheConnector;

    public void setJdbcCacheConnector(JdbcCacheConnector jdbcCacheConnector) {
        this.jdbcCacheConnector = jdbcCacheConnector;
    }

    protected SqlQuery getCreateTableQuery() {
        return SQL_INIT_CREATE_TABLE;
    }

    protected SqlQuery getTableExistenceQuery() {
        return SQL_INIT_CHECK_EXISTENCE;
    }

    protected SqlQuery getDeleteTableQuery() {
        return SQL_DROP_TABLE;
    }

    protected SqlQuery getInsertCertificateTokenEntryQuery() {
        return SQL_FIND_INSERT;
    }

    protected SqlQuery getRemoveCertificateTokenEntryQuery() {
        return SQL_FIND_REMOVE;
    }

    protected SqlSelectQuery getAIACertificatesExtractQuery() {
        return SQL_FIND_QUERY;
    }

    protected SqlSelectQuery getAIAKeysExtractQuery() {
        return SQL_DISTINCT_AIA_KEYS_QUERY;
    }

    protected Set<CertificateToken> findCertificates(String key) {
        Collection records = this.jdbcCacheConnector.select(this.getAIACertificatesExtractQuery(), new Object[]{key});
        return this.buildCertificatesFromResult(records);
    }

    private Set<CertificateToken> buildCertificatesFromResult(Collection<SqlRecord> records) {
        try {
            LinkedHashSet<CertificateToken> certificateTokens = new LinkedHashSet<CertificateToken>();
            for (SqlRecord resultRecord : records) {
                CertificateToken certificateToken;
                SqlAIAResponse aiaResponse = (SqlAIAResponse)resultRecord;
                byte[] binaries = aiaResponse.certificateBinary;
                if (!Utils.isArrayNotEmpty((byte[])binaries) || (certificateToken = DSSUtils.loadCertificate((byte[])binaries)) == null) continue;
                certificateTokens.add(certificateToken);
            }
            return certificateTokens;
        }
        catch (Exception e) {
            throw new DSSExternalResourceException(String.format("An error occurred during an attempt to get a certificate token from cache. Reason : %s", e.getMessage()), (Throwable)e);
        }
    }

    @Deprecated
    protected void insertCertificates(String aiaKey, Collection<CertificateToken> certificateTokens) {
        if (Utils.isCollectionNotEmpty(certificateTokens)) {
            for (CertificateToken certificate : certificateTokens) {
                this.insertCertificate(aiaKey, certificate);
            }
        }
    }

    protected void insertCertificate(String aiaKey, CertificateToken certificateTokens) {
        if (certificateTokens != null && aiaKey != null) {
            this.jdbcCacheConnector.execute(this.getInsertCertificateTokenEntryQuery(), new Object[]{this.getUniqueCertificateAiaId(certificateTokens, aiaKey), aiaKey, certificateTokens.getEncoded()});
            LOG.debug("AIA Certificate with Id '{}' successfully inserted in DB", (Object)certificateTokens.getDSSIdAsString());
        }
    }

    protected void removeCertificates(String aiaKey) {
        this.jdbcCacheConnector.execute(this.getRemoveCertificateTokenEntryQuery(), new Object[]{aiaKey});
        LOG.debug("Certificate tokens with AIA key '{}' successfully removed from DB", (Object)aiaKey);
    }

    protected List<String> getExistingAIAKeys() {
        Collection result = this.jdbcCacheConnector.select(this.getAIAKeysExtractQuery(), new Object[0]);
        return result.stream().map(r -> ((SqlAIAResponse)r).aiaKey).collect(Collectors.toList());
    }

    public void initTable() throws SQLException {
        if (!this.isTableExists()) {
            LOG.debug("Table does not exist. Creating a new table...");
            this.createTable();
            LOG.info("Table was created.");
        } else {
            LOG.debug("Table already exists.");
        }
    }

    public boolean isTableExists() {
        return this.jdbcCacheConnector.tableQuery(this.getTableExistenceQuery());
    }

    private void createTable() throws SQLException {
        this.jdbcCacheConnector.executeThrowable(this.getCreateTableQuery());
    }

    public void destroyTable() throws SQLException {
        if (this.isTableExists()) {
            LOG.debug("Table exists. Removing the table...");
            this.dropTable();
            LOG.info("Table was destroyed.");
        } else {
            LOG.warn("Cannot drop the table. Table does not exist.");
        }
    }

    private void dropTable() throws SQLException {
        this.jdbcCacheConnector.executeThrowable(this.getDeleteTableQuery());
    }

    protected static class SqlAIAResponse
    implements SqlRecord {
        protected String id;
        protected String aiaKey;
        protected byte[] certificateBinary;

        protected SqlAIAResponse() {
        }
    }
}

