<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:fox="http://xmlgraphics.apache.org/fop/extensions"
	xmlns:dss="http://dss.esig.europa.eu/validation/simple-certificate-report">
	<xsl:output method="xml" indent="yes" />

	<xsl:param name="rootTrustmarkUrlInTlBrowser">
		https://esignature.ec.europa.eu/efda/tl-browser/#/screen/tl/trustmark/
	</xsl:param>
	<xsl:param name="rootCountryUrlInTlBrowser">
		https://esignature.ec.europa.eu/efda/tl-browser/#/screen/tl/
	</xsl:param>

	<xsl:template match="/dss:SimpleCertificateReport">
		<fo:root>
			<xsl:attribute name="font-family">sans-serif</xsl:attribute>
			
			<fo:layout-master-set>
				<fo:simple-page-master>
					<xsl:attribute name="master-name">A4-portrait</xsl:attribute>
					<xsl:attribute name="page-height">29.7cm</xsl:attribute>
					<xsl:attribute name="page-width">21cm</xsl:attribute>
					<xsl:attribute name="margin-top">1cm</xsl:attribute>
					<xsl:attribute name="margin-bottom">1cm</xsl:attribute>
					<xsl:attribute name="margin-right">2.5cm</xsl:attribute>
					<xsl:attribute name="margin-left">2.5cm</xsl:attribute>
			
					<fo:region-body>
						<xsl:attribute name="margin-top">1cm</xsl:attribute>
						<xsl:attribute name="margin-bottom">1cm</xsl:attribute>
					</fo:region-body>

					<fo:region-after>
						<xsl:attribute name="region-name">page-footer</xsl:attribute>
						<xsl:attribute name="extent">0.5cm</xsl:attribute>
					</fo:region-after>
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence>
				<xsl:attribute name="master-reference">A4-portrait</xsl:attribute>
	
				<fo:static-content>
					<xsl:attribute name="flow-name">page-footer</xsl:attribute>
					<xsl:attribute name="font-size">5pt</xsl:attribute>
					
					<fo:block>
						<xsl:attribute name="color">grey</xsl:attribute>
						<xsl:attribute name="border-top-style">solid</xsl:attribute>
						<xsl:attribute name="border-top-color">grey</xsl:attribute>
						<xsl:attribute name="text-align-last">justify</xsl:attribute>
						<xsl:attribute name="padding-top">3px</xsl:attribute>
					
						<fo:inline>
							 <fo:basic-link>
							 	<xsl:attribute name="external-destination">url('https://github.com/esig/dss')</xsl:attribute>
							 	Generated by DSS v.5.11.1.d4j.1
							 </fo:basic-link>
							 <xsl:text>with validation time </xsl:text><xsl:value-of select="@ValidationTime" />
						</fo:inline>
						
						<fo:leader/>

						<fo:inline>
							<fo:page-number />
							/
							<fo:page-number-citation>
								<xsl:attribute name="ref-id">theEnd</xsl:attribute>
							</fo:page-number-citation> 
						</fo:inline>
					</fo:block>
				</fo:static-content>

				<fo:flow>
					<xsl:attribute name="flow-name">xsl-region-body</xsl:attribute>
					<xsl:attribute name="font-size">8pt</xsl:attribute>
					
					<xsl:apply-templates select="dss:Chain"/>
	    			
					<fo:block>
						<xsl:attribute name="id">theEnd</xsl:attribute>
					</fo:block>
				</fo:flow>
				
			</fo:page-sequence>

		</fo:root>
		
	</xsl:template>
    
    <xsl:template match="dss:Chain">
    
    	<xsl:for-each select="//dss:ChainItem">
			<fo:block-container>
				<xsl:attribute name="margin-top">4px</xsl:attribute>
				<fo:block-container>
					<xsl:attribute name="margin">0</xsl:attribute>
					
					<fo:block>
						<xsl:attribute name="keep-with-next">always</xsl:attribute>
						<xsl:attribute name="font-weight">bold</xsl:attribute>
			       		
			       		<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
			       		<xsl:attribute name="border-color">#004494</xsl:attribute>
			       		<xsl:attribute name="border-width">1px</xsl:attribute>
			       		
						<xsl:attribute name="margin-bottom">2px</xsl:attribute>
						
						<xsl:text>Certificate : <xsl:value-of select="dss:id"/></xsl:text>
			    	</fo:block>
		    	</fo:block-container>
			</fo:block-container>
			
			
			<fo:block-container>
	       		<xsl:attribute name="border-left-style">solid</xsl:attribute>
	       		<xsl:attribute name="border-color">#004494</xsl:attribute>
	       		<xsl:attribute name="border-width">1px</xsl:attribute>
	       		
				<xsl:attribute name="margin-top">7px</xsl:attribute>
				<xsl:attribute name="margin-bottom">5px</xsl:attribute>
	       		
				<fo:block-container>
					<xsl:attribute name="margin-left">10px</xsl:attribute>
					
					<fo:block-container>
						<xsl:attribute name="margin">0</xsl:attribute>
					
						<fo:block>
							<xsl:attribute name="margin-top">5px</xsl:attribute>
							<xsl:attribute name="margin-bottom">5px</xsl:attribute>
							<xsl:attribute name="font-size">7pt</xsl:attribute>
							
							<fo:table table-layout="fixed">
								<fo:table-column>
									<xsl:attribute name="column-width">25%</xsl:attribute>
								</fo:table-column>
								<fo:table-column>
									<xsl:attribute name="column-width">75%</xsl:attribute>
								</fo:table-column>
								
								<fo:table-body>
									<xsl:attribute name="start-indent">0</xsl:attribute>
									<xsl:attribute name="end-indent">0</xsl:attribute>
									
									<fo:table-row>
										<xsl:variable name="indicationText" select="dss:Indication/text()"/>
										<xsl:variable name="indicationColor">
								        	<xsl:choose>
												<xsl:when test="$indicationText='TOTAL_PASSED'">green</xsl:when>
												<xsl:when test="$indicationText='PASSED'">green</xsl:when>
												<xsl:when test="$indicationText='INDETERMINATE'">orange</xsl:when>
												<xsl:when test="$indicationText='FAILED'">red</xsl:when>
												<xsl:when test="$indicationText='TOTAL_FAILED'">red</xsl:when>
											</xsl:choose>
								        </xsl:variable>
        
										<fo:table-cell>
											<fo:block>
												<xsl:attribute name="margin-top">1px</xsl:attribute>
												<xsl:attribute name="margin-bottom">1px</xsl:attribute>
												
												<xsl:attribute name="font-weight">bold</xsl:attribute>
												<xsl:text>Indication :</xsl:text>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell>
											<fo:block>
												<xsl:attribute name="margin-top">1px</xsl:attribute>
												<xsl:attribute name="margin-bottom">1px</xsl:attribute>
											
						       					<xsl:attribute name="font-weight">bold</xsl:attribute>
												<xsl:attribute name="font-size">7pt</xsl:attribute>
												
						       					<xsl:attribute name="color"><xsl:value-of select="$indicationColor" /></xsl:attribute>
						       					<xsl:variable name="subIndication"><xsl:value-of select="dss:SubIndication" /></xsl:variable>
												<xsl:value-of select="$indicationText" /><xsl:if test="$subIndication != ''"> - <xsl:value-of select="dss:SubIndication" /></xsl:if>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									
     								<xsl:apply-templates select="dss:qualificationAtIssuance"/>
     								<xsl:apply-templates select="dss:qualificationAtValidation"/>
			       					<xsl:apply-templates select="*[not(self::dss:qualificationAtIssuance | self::dss:qualificationAtValidation)]"/>
     								<xsl:apply-templates select="dss:enactedMRA"/>
			       					
								</fo:table-body>
							</fo:table>
						
				       	</fo:block>
			       	</fo:block-container>
		       	</fo:block-container>
		       	
	    	</fo:block-container>
    	</xsl:for-each>
		
    </xsl:template>
    
    <xsl:template match="dss:subject">
    	<xsl:apply-templates/>
    </xsl:template>
    
    <xsl:template match="dss:commonName|dss:surname|dss:givenName|dss:pseudonym|dss:organizationName|
    		dss:organizationUnit|dss:email|dss:locality|dss:state|dss:country|
    		dss:issuerId|dss:notBefore|dss:notAfter">
		 <xsl:variable name="label">
        	<xsl:choose>
				<xsl:when test="name()='commonName'">Common name</xsl:when>
				<xsl:when test="name()='surname'">Surname</xsl:when>
				<xsl:when test="name()='givenName'">Given name</xsl:when>
				<xsl:when test="name()='pseudonym'">Pseudonym</xsl:when>
				<xsl:when test="name()='organizationName'">Organization name</xsl:when>
				<xsl:when test="name()='organizationUnit'">Organization unit</xsl:when>
				<xsl:when test="name()='email'">Email</xsl:when>
				<xsl:when test="name()='locality'">Locality</xsl:when>
				<xsl:when test="name()='state'">State</xsl:when>
				<xsl:when test="name()='country'">Country</xsl:when>
				<xsl:when test="name()='issuerId'">Issuer Id</xsl:when>
				<xsl:when test="name()='notBefore'">Not Before</xsl:when>
				<xsl:when test="name()='notAfter'">Not After</xsl:when>
				<xsl:otherwise>?</xsl:otherwise>
			</xsl:choose>
        </xsl:variable>
        
		<fo:table-row>
			<fo:table-cell>
				<fo:block>
					<xsl:attribute name="margin-top">1px</xsl:attribute>
					<xsl:attribute name="margin-bottom">1px</xsl:attribute>
					
					<xsl:attribute name="font-weight">bold</xsl:attribute>
					<xsl:value-of select="$label" /><xsl:text> :</xsl:text>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block>
					<xsl:attribute name="margin-top">1px</xsl:attribute>
					<xsl:attribute name="margin-bottom">1px</xsl:attribute>
					
					<xsl:value-of select="." />
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
    </xsl:template>
    
    <xsl:template match="dss:keyUsages">
    	<xsl:if test="node() != ''">
			<fo:table-row>
				<fo:table-cell>
					<fo:block>
						<xsl:attribute name="margin-top">1px</xsl:attribute>
						<xsl:attribute name="margin-bottom">1px</xsl:attribute>
						
						<xsl:attribute name="font-weight">bold</xsl:attribute>
						<xsl:text>Key usages :</xsl:text>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<xsl:for-each select="dss:keyUsage">
						<fo:block>
							<xsl:attribute name="margin-top">1px</xsl:attribute>
							<xsl:attribute name="margin-bottom">1px</xsl:attribute>
							
							<xsl:value-of select="." />
						</fo:block>
					</xsl:for-each>
				</fo:table-cell>
			</fo:table-row>
		</xsl:if>
    </xsl:template>
    
    <xsl:template match="dss:extendedKeyUsages|dss:ocspUrls|dss:crlUrls|dss:aiaUrls|dss:cpsUrls|dss:pdsUrls">
    	<xsl:if test="node() != ''">
			 <xsl:variable name="label">
	        	<xsl:choose>
					<xsl:when test="name()='extendedKeyUsages'">Extended key usages</xsl:when>
					<xsl:when test="name()='ocspUrls'">OCSP urls</xsl:when>
					<xsl:when test="name()='crlUrls'">CRL urls</xsl:when>
					<xsl:when test="name()='aiaUrls'">AIA urls</xsl:when>
					<xsl:when test="name()='cpsUrls'">CPS urls</xsl:when>
					<xsl:when test="name()='pdsUrls'">PDS urls</xsl:when>
					<xsl:otherwise>?</xsl:otherwise>
				</xsl:choose>
	        </xsl:variable>
	        
			<fo:table-row>
				<fo:table-cell>
					<fo:block>
						<xsl:attribute name="margin-top">1px</xsl:attribute>
						<xsl:attribute name="margin-bottom">1px</xsl:attribute>
						
						<xsl:attribute name="font-weight">bold</xsl:attribute>
						<xsl:value-of select="$label" /><xsl:text> :</xsl:text>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<xsl:apply-templates/>
				</fo:table-cell>
			</fo:table-row>
		</xsl:if>
    </xsl:template>
    
    <xsl:template match="dss:extendedKeyUsage">
    	<fo:block>
			<xsl:attribute name="margin-top">1px</xsl:attribute>
			<xsl:attribute name="margin-bottom">1px</xsl:attribute>
			
			<xsl:value-of select="." />
		</fo:block>
    </xsl:template>
    
    <xsl:template match="dss:ocspUrl|dss:crlUrl|dss:aiaUrl|dss:cpsUrl|dss:pdsUrl">
		<xsl:variable name="url" select="." />
    	<fo:block>
			<xsl:attribute name="margin-top">1px</xsl:attribute>
			<xsl:attribute name="margin-bottom">1px</xsl:attribute>
			
			<fo:basic-link>
			 	<xsl:attribute name="external-destination"><xsl:value-of select="$url" /></xsl:attribute>
			 	<xsl:value-of select="$url" />
			 </fo:basic-link>
		</fo:block>
    </xsl:template>
    
    <xsl:template match="dss:qualificationAtIssuance|dss:qualificationAtValidation">
		 <xsl:variable name="label">
        	<xsl:choose>
				<xsl:when test="name()='qualificationAtIssuance'">Qualification at issuance time</xsl:when>
				<xsl:when test="name()='qualificationAtValidation'">Qualification at validation time</xsl:when>
				<xsl:otherwise>?</xsl:otherwise>
			</xsl:choose>
        </xsl:variable>
        
		<fo:table-row>
			<fo:table-cell>
				<fo:block>
					<xsl:attribute name="margin-top">1px</xsl:attribute>
					<xsl:attribute name="margin-bottom">1px</xsl:attribute>
					
					<xsl:attribute name="font-weight">bold</xsl:attribute>
					<xsl:value-of select="$label" /><xsl:text> :</xsl:text>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block>
					<xsl:attribute name="margin-top">1px</xsl:attribute>
					<xsl:attribute name="margin-bottom">1px</xsl:attribute>
					<xsl:attribute name="font-size">7pt</xsl:attribute>
					<xsl:attribute name="font-weight">bold</xsl:attribute>
					
					<xsl:value-of select="." />
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
    </xsl:template>
    
    
    <xsl:template match="dss:enactedMRA">
        
		<fo:table-row>
			<fo:table-cell>
				<fo:block>
					<xsl:attribute name="margin-top">1px</xsl:attribute>
					<xsl:attribute name="margin-bottom">1px</xsl:attribute>
					
				</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block>
					<xsl:attribute name="margin-top">1px</xsl:attribute>
					<xsl:attribute name="margin-bottom">1px</xsl:attribute>
					<xsl:attribute name="font-size">7pt</xsl:attribute>
					<xsl:attribute name="font-weight">bold</xsl:attribute>
					The qualification level has been determined using an enacted trust service equivalence mapping.
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
    </xsl:template>
    
    <xsl:template match="dss:revocation">
    
	   	<xsl:choose>
			<xsl:when test="dss:thisUpdate">
	    		<fo:table-row>
					<fo:table-cell>
						<fo:block>
							<xsl:attribute name="margin-top">1px</xsl:attribute>
							<xsl:attribute name="margin-bottom">1px</xsl:attribute>
							
							<xsl:attribute name="font-weight">bold</xsl:attribute>
							<xsl:text>Revocation thisUpdate time :</xsl:text>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block>
							<xsl:attribute name="margin-top">1px</xsl:attribute>
							<xsl:attribute name="margin-bottom">1px</xsl:attribute>
							
							<xsl:value-of select="dss:thisUpdate" />
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			   	<fo:table-row>
					<fo:table-cell>
						<fo:block>
							<xsl:attribute name="margin-top">1px</xsl:attribute>
							<xsl:attribute name="margin-bottom">1px</xsl:attribute>
							
							<xsl:attribute name="font-weight">bold</xsl:attribute>
							<xsl:text>Revocation status :</xsl:text>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block>
							<xsl:attribute name="margin-top">1px</xsl:attribute>
							<xsl:attribute name="margin-bottom">1px</xsl:attribute>
							
							
						   	<xsl:choose>
								<xsl:when test="dss:revocationDate">
						    		<xsl:text>Revoked (reason: </xsl:text><xsl:value-of select="dss:revocationReason" /> @ <xsl:value-of select="dss:revocationDate" />)
								</xsl:when>
								<xsl:otherwise>
						     		<xsl:text>Not revoked</xsl:text>
								</xsl:otherwise>
						   	</xsl:choose>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
	    	</xsl:when>
			<xsl:otherwise>
	     		<fo:table-row>
					<fo:table-cell>
						<fo:block>
							<xsl:attribute name="margin-top">1px</xsl:attribute>
							<xsl:attribute name="margin-bottom">1px</xsl:attribute>
							
							<xsl:attribute name="font-weight">bold</xsl:attribute>
							<xsl:text>Revocation :</xsl:text>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block>
							<xsl:attribute name="margin-top">1px</xsl:attribute>
							<xsl:attribute name="margin-bottom">1px</xsl:attribute>
							
							<xsl:text>No revocation data available</xsl:text>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</xsl:otherwise>
    	</xsl:choose>
    	
    </xsl:template>
    
    <xsl:template match="dss:trustAnchors">
    	<xsl:if test="node() != ''">
	  		<fo:table-row>
				<fo:table-cell>
					<fo:block>
						<xsl:attribute name="margin-top">1px</xsl:attribute>
						<xsl:attribute name="margin-bottom">1px</xsl:attribute>
						
						<xsl:attribute name="font-weight">bold</xsl:attribute>
						<xsl:text>Trust anchor(s) :</xsl:text>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<xsl:attribute name="display-align">center</xsl:attribute>
					
			    	<xsl:for-each select="dss:trustAnchor">
						<xsl:variable name="countryTlUrl" select="concat($rootCountryUrlInTlBrowser, dss:countryCode)" />
						<xsl:variable name="countryTspUrl" select="concat($rootTrustmarkUrlInTlBrowser, dss:countryCode, '/', dss:trustServiceProviderRegistrationId)" />
						<fo:block>
							<xsl:attribute name="margin-top">1px</xsl:attribute>
							<xsl:attribute name="margin-bottom">1px</xsl:attribute>
							
							<fo:basic-link>
								<xsl:attribute name="external-destination"><xsl:value-of select="$countryTlUrl"/></xsl:attribute>
								<xsl:value-of select="dss:countryCode" />
							</fo:basic-link>
							<xsl:text> </xsl:text>
							<fo:instream-foreign-object fox:alt-text="arrow-right" content-height="6px" content-width="6px" height="6px" width="6px">
								<svg viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path style="fill:black" d="M1413 896q0-27-18-45l-91-91-362-362q-18-18-45-18t-45 18l-91 91q-18 18-18 45t18 45l189 189h-502q-26 0-45 19t-19 45v128q0 26 19 45t45 19h502l-189 189q-19 19-19 45t19 45l91 91q18 18 45 18t45-18l362-362 91-91q18-18 18-45zm251 0q0 209-103 385.5t-279.5 279.5-385.5 103-385.5-103-279.5-279.5-103-385.5 103-385.5 279.5-279.5 385.5-103 385.5 103 279.5 279.5 103 385.5z"/></svg>
							</fo:instream-foreign-object>
							<xsl:text> </xsl:text>
							<fo:basic-link>
								<xsl:attribute name="external-destination"><xsl:value-of select="$countryTspUrl"/></xsl:attribute>
							<xsl:value-of select="dss:trustServiceProvider" />
							</fo:basic-link>
							<xsl:text> </xsl:text>
							<fo:instream-foreign-object fox:alt-text="arrow-right" content-height="6px" content-width="6px" height="6px" width="6px">
								<svg viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path style="fill:black" d="M1413 896q0-27-18-45l-91-91-362-362q-18-18-45-18t-45 18l-91 91q-18 18-18 45t18 45l189 189h-502q-26 0-45 19t-19 45v128q0 26 19 45t45 19h502l-189 189q-19 19-19 45t19 45l91 91q18 18 45 18t45-18l362-362 91-91q18-18 18-45zm251 0q0 209-103 385.5t-279.5 279.5-385.5 103-385.5-103-279.5-279.5-103-385.5 103-385.5 279.5-279.5 385.5-103 385.5 103 279.5 279.5 103 385.5z"/></svg>
							</fo:instream-foreign-object>
							<xsl:text> </xsl:text>
							<xsl:value-of select="dss:trustServiceName" />
						</fo:block>
			    	</xsl:for-each>
				</fo:table-cell>
			</fo:table-row>
		</xsl:if>
    </xsl:template>

</xsl:stylesheet>