/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss;

import java.util.ResourceBundle;

public class DSSNotETSICompliantException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private ResourceBundle bundle = ResourceBundle.getBundle("eu/europa/esig/dss/i18n");
    private MSG key;
    private String more;

    public DSSNotETSICompliantException(MSG message) {
        this.init(message);
    }

    public DSSNotETSICompliantException(MSG message, String more) {
        this.init(message);
        this.more = more;
    }

    public DSSNotETSICompliantException(MSG message, Throwable cause) {
        super(cause);
        this.init(message);
    }

    private void init(MSG message) {
        if (message == null) {
            throw new IllegalArgumentException("Cannot build Exception without a message");
        }
        this.key = message;
    }

    @Override
    public String getLocalizedMessage() {
        String bundleString = this.bundle.getString(this.key.toString());
        return bundleString + (this.more != null ? " / " + this.more : "");
    }

    @Override
    public String getMessage() {
        return this.getLocalizedMessage();
    }

    public static enum MSG {
        TSL_NOT_SIGNED,
        MORE_THAN_ONE_SIGNATURE,
        DIFFERENT_SIGNATURE_FORMATS,
        SIGNATURE_INVALID,
        NOT_A_VALID_XML,
        UNRECOGNIZED_TAG,
        UNSUPPORTED_ASSERT,
        XADES_DIGEST_ALG_AND_VALUE_ENCODING,
        ASICS_CADES,
        NO_SIGNING_TIME,
        NO_SIGNING_CERTIFICATE;

    }
}

