/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl;

import eu.europa.esig.dss.DSSASN1Utils;
import eu.europa.esig.dss.tsl.Condition;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.x509.CertificateToken;
import java.util.List;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;

public class ExtendedKeyUsageCondition
extends Condition {
    private static final long serialVersionUID = -5969735320082024885L;
    private final List<String> extendedKeyUsageOids;

    public ExtendedKeyUsageCondition(List<String> oids) {
        this.extendedKeyUsageOids = oids;
    }

    public boolean check(CertificateToken certificateToken) {
        if (Utils.isCollectionNotEmpty(this.extendedKeyUsageOids)) {
            for (String oid : this.extendedKeyUsageOids) {
                if (DSSASN1Utils.isExtendedKeyUsagePresent(certificateToken, new ASN1ObjectIdentifier(oid))) continue;
                return false;
            }
        }
        return true;
    }

    public String toString(String indent) {
        if (indent == null) {
            indent = "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(indent).append("ExtendedKeyUsageCondition: ").append(this.extendedKeyUsageOids).append('\n');
        return builder.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

