/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl;

import eu.europa.esig.dss.DSSNotApplicableMethodException;
import eu.europa.esig.dss.tsl.TLInfo;
import eu.europa.esig.dss.x509.CertificateSourceType;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.CommonTrustedCertificateSource;
import java.util.HashMap;
import java.util.Map;

public class TrustedListsCertificateSource
extends CommonTrustedCertificateSource {
    private Map<String, TLInfo> tlInfos = new HashMap<String, TLInfo>();

    @Override
    protected CertificateSourceType getCertificateSourceType() {
        return CertificateSourceType.TRUSTED_LIST;
    }

    @Override
    public CertificateToken addCertificate(CertificateToken certificate) {
        throw new DSSNotApplicableMethodException(this.getClass());
    }

    public void updateTlInfo(String countryCode, TLInfo info) {
        this.tlInfos.put(countryCode, info);
    }

    public TLInfo getTlInfo(String countryCode) {
        return this.tlInfos.get(countryCode);
    }

    public TLInfo getLotlInfo() {
        for (TLInfo tlInfo : this.tlInfos.values()) {
            if (!tlInfo.isLotl()) continue;
            return tlInfo;
        }
        return null;
    }

    public Map<String, TLInfo> getSummary() {
        return this.tlInfos;
    }
}

