/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.MimeType;
import eu.europa.esig.dss.utils.Utils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.EnumMap;

public abstract class CommonDocument
implements DSSDocument {
    protected EnumMap<DigestAlgorithm, String> base64EncodeDigestMap = new EnumMap(DigestAlgorithm.class);
    protected MimeType mimeType;
    protected String name;
    protected String absolutePath;

    public void save(String path) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(path);){
            this.writeTo(fos);
        }
    }

    public void writeTo(OutputStream stream) throws IOException {
        byte[] buffer = new byte[1024];
        int count = -1;
        try (InputStream inStream = this.openStream();){
            while ((count = inStream.read(buffer)) > 0) {
                stream.write(buffer, 0, count);
            }
        }
    }

    public MimeType getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(MimeType mimeType) {
        this.mimeType = mimeType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public void setAbsolutePath(String absolutePath) {
        this.absolutePath = absolutePath;
    }

    public String getDigest(DigestAlgorithm digestAlgorithm) {
        String base64EncodeDigest = this.base64EncodeDigestMap.get(digestAlgorithm);
        if (base64EncodeDigest == null) {
            byte[] digestBytes = DSSUtils.digest(digestAlgorithm, this);
            base64EncodeDigest = Utils.toBase64((byte[])digestBytes);
            this.base64EncodeDigestMap.put(digestAlgorithm, base64EncodeDigest);
        }
        return base64EncodeDigest;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        stringWriter.append("Name: " + this.getName()).append(" / ").append(this.mimeType == null ? "" : this.mimeType.getMimeTypeString()).append(" / ").append(this.getAbsolutePath());
        return stringWriter.toString();
    }
}

