/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss;

import eu.europa.esig.dss.DSSASN1Utils;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.x509.CertificateToken;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.ocsp.OCSPResponse;
import org.bouncycastle.asn1.ocsp.OCSPResponseStatus;
import org.bouncycastle.asn1.ocsp.ResponseBytes;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;

public final class DSSRevocationUtils {
    private static JcaDigestCalculatorProviderBuilder jcaDigestCalculatorProviderBuilder = new JcaDigestCalculatorProviderBuilder();

    private DSSRevocationUtils() {
    }

    public static BasicOCSPResp fromRespToBasic(OCSPResp ocspResp) {
        try {
            return (BasicOCSPResp)ocspResp.getResponseObject();
        }
        catch (OCSPException e) {
            throw new DSSException((Throwable)e);
        }
    }

    public static OCSPResp fromBasicToResp(BasicOCSPResp basicOCSPResp) {
        try {
            byte[] encoded = basicOCSPResp.getEncoded();
            return DSSRevocationUtils.fromBasicToResp(encoded);
        }
        catch (IOException e) {
            throw new DSSException((Throwable)e);
        }
    }

    public static OCSPResp fromBasicToResp(byte[] basicOCSPRespBinary) {
        OCSPResponseStatus responseStatus = new OCSPResponseStatus(0);
        DEROctetString derBasicOCSPResp = new DEROctetString(basicOCSPRespBinary);
        ResponseBytes responseBytes = new ResponseBytes(OCSPObjectIdentifiers.id_pkix_ocsp_basic, (ASN1OctetString)derBasicOCSPResp);
        OCSPResponse ocspResponse = new OCSPResponse(responseStatus, responseBytes);
        return new OCSPResp(ocspResponse);
    }

    public static boolean matches(CertificateID certId, SingleResp singleResp) {
        CertificateID singleRespCertID = singleResp.getCertID();
        ASN1ObjectIdentifier singleRespCertIDHashAlgOID = singleRespCertID.getHashAlgOID();
        byte[] singleRespCertIDIssuerKeyHash = singleRespCertID.getIssuerKeyHash();
        byte[] singleRespCertIDIssuerNameHash = singleRespCertID.getIssuerNameHash();
        BigInteger singleRespCertIDSerialNumber = singleRespCertID.getSerialNumber();
        ASN1ObjectIdentifier certIdHashAlgOID = certId.getHashAlgOID();
        byte[] certIdIssuerKeyHash = certId.getIssuerKeyHash();
        byte[] certIdIssuerNameHash = certId.getIssuerNameHash();
        BigInteger certIdSerialNumber = certId.getSerialNumber();
        return singleRespCertIDHashAlgOID.equals((Object)certIdHashAlgOID) && Arrays.equals(singleRespCertIDIssuerKeyHash, certIdIssuerKeyHash) && Arrays.equals(singleRespCertIDIssuerNameHash, certIdIssuerNameHash) && singleRespCertIDSerialNumber.equals(certIdSerialNumber);
    }

    public static CertificateID getOCSPCertificateID(CertificateToken cert, CertificateToken issuerCert) {
        try {
            BigInteger serialNumber = cert.getSerialNumber();
            DigestCalculator digestCalculator = DSSRevocationUtils.getSHA1DigestCalculator();
            X509CertificateHolder x509CertificateHolder = DSSASN1Utils.getX509CertificateHolder(issuerCert);
            return new CertificateID(digestCalculator, x509CertificateHolder, serialNumber);
        }
        catch (OCSPException e) {
            throw new DSSException("Unable to create CertificateID", (Throwable)e);
        }
    }

    public static DigestCalculator getSHA1DigestCalculator() {
        try {
            DigestCalculatorProvider digestCalculatorProvider = jcaDigestCalculatorProviderBuilder.build();
            return digestCalculatorProvider.get(CertificateID.HASH_SHA1);
        }
        catch (OperatorCreationException e) {
            throw new DSSException("Unable to create a DigestCalculator instance", (Throwable)e);
        }
    }

    public static BasicOCSPResp loadOCSPBase64Encoded(String base64Encoded) throws IOException {
        byte[] derEncoded = Utils.fromBase64((String)base64Encoded);
        OCSPResp ocspResp = new OCSPResp(derEncoded);
        return DSSRevocationUtils.fromRespToBasic(ocspResp);
    }

    public static byte[] getEncoded(OCSPResp ocspResp) {
        try {
            return ocspResp.getEncoded();
        }
        catch (IOException e) {
            throw new DSSException((Throwable)e);
        }
    }

    static {
        jcaDigestCalculatorProviderBuilder.setProvider("BC");
    }
}

