/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.x509;

import eu.europa.esig.dss.x509.CertificatePool;
import eu.europa.esig.dss.x509.CertificateSource;
import eu.europa.esig.dss.x509.CertificateSourceType;
import eu.europa.esig.dss.x509.CertificateToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.security.auth.x500.X500Principal;

public class CommonCertificateSource
implements CertificateSource {
    private final CertificatePool certPool;
    private final List<CertificateToken> certificateTokens = new ArrayList<CertificateToken>();

    public CommonCertificateSource() {
        this.certPool = new CertificatePool();
    }

    public CommonCertificateSource(CertificatePool certPool) {
        Objects.requireNonNull(certPool, "Certificate pool is missing");
        this.certPool = certPool;
    }

    @Override
    public CertificateSourceType getCertificateSourceType() {
        return CertificateSourceType.OTHER;
    }

    @Override
    public CertificatePool getCertificatePool() {
        return this.certPool;
    }

    @Override
    public CertificateToken addCertificate(CertificateToken token) {
        CertificateToken certToken = this.certPool.getInstance(token, this.getCertificateSourceType());
        if (!this.certificateTokens.contains(certToken)) {
            this.certificateTokens.add(certToken);
        }
        return certToken;
    }

    @Override
    public List<CertificateToken> getCertificates() {
        return Collections.unmodifiableList(this.certificateTokens);
    }

    @Override
    public List<CertificateToken> get(X500Principal x500Principal) {
        List<Object> certificateTokenList = null;
        if (x500Principal != null) {
            ArrayList<CertificateToken> missingCertificateTokens = new ArrayList<CertificateToken>();
            certificateTokenList = this.certPool.get(x500Principal);
            for (CertificateToken certificateToken : certificateTokenList) {
                if (this.certificateTokens.contains(certificateToken)) continue;
                missingCertificateTokens.add(certificateToken);
            }
            if (missingCertificateTokens.size() > 0) {
                certificateTokenList.removeAll(missingCertificateTokens);
            }
        } else {
            certificateTokenList = new ArrayList();
        }
        return Collections.unmodifiableList(certificateTokenList);
    }

    public boolean removeCertificate(CertificateToken certificate) {
        return this.certificateTokens.remove(certificate);
    }

    public int getNumberOfCertificates() {
        return this.certificateTokens.size();
    }
}

