/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.x509.crl;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.crl.CRLUtils;
import eu.europa.esig.dss.crl.CRLValidity;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.RevocationToken;
import eu.europa.esig.dss.x509.crl.CRLReasonEnum;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.cert.CRLReason;
import java.security.cert.X509CRLEntry;
import javax.security.auth.x500.X500Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRLToken
extends RevocationToken {
    private static final Logger LOG = LoggerFactory.getLogger(CRLToken.class);
    private final CRLValidity crlValidity;

    public CRLToken(CertificateToken certificateToken, CRLValidity crlValidity) {
        if (crlValidity == null) {
            throw new NullPointerException();
        }
        this.crlValidity = crlValidity;
        this.copyCommonValuesFromCRL();
        this.setRevocationStatus(certificateToken);
        LOG.debug("+CRLToken");
    }

    private void copyCommonValuesFromCRL() {
        this.signatureAlgorithm = this.crlValidity.getSignatureAlgorithm();
        this.thisUpdate = this.crlValidity.getThisUpdate();
        this.productionDate = this.crlValidity.getThisUpdate();
        this.nextUpdate = this.crlValidity.getNextUpdate();
        this.expiredCertsOnCRL = this.crlValidity.getExpiredCertsOnCRL();
        CertificateToken issuerToken = this.crlValidity.getIssuerToken();
        if (issuerToken != null) {
            this.publicKeyOfTheSigner = issuerToken.getPublicKey();
        }
        this.signatureValid = this.crlValidity.isSignatureIntact();
        this.signatureInvalidityReason = this.crlValidity.getSignatureInvalidityReason();
    }

    private void setRevocationStatus(CertificateToken certificateToken) {
        X500Principal issuerToken = certificateToken.getIssuerX500Principal();
        CertificateToken crlSigner = this.crlValidity.getIssuerToken();
        X500Principal crlSignerSubject = null;
        if (crlSigner != null) {
            crlSignerSubject = crlSigner.getSubjectX500Principal();
        }
        if (!DSSUtils.x500PrincipalAreEquals(issuerToken, crlSignerSubject)) {
            if (!this.crlValidity.isSignatureIntact()) {
                throw new DSSException(this.crlValidity.getSignatureInvalidityReason());
            }
            throw new DSSException("The CRLToken is not signed by the same issuer as the CertificateToken to be verified!");
        }
        BigInteger serialNumber = certificateToken.getSerialNumber();
        X509CRLEntry crlEntry = CRLUtils.getRevocationInfo((CRLValidity)this.crlValidity, (BigInteger)serialNumber);
        this.status = null == crlEntry;
        if (!this.status.booleanValue()) {
            this.revocationDate = crlEntry.getRevocationDate();
            CRLReason revocationReason = crlEntry.getRevocationReason();
            if (revocationReason != null) {
                this.reason = CRLReasonEnum.fromInt((int)revocationReason.ordinal());
            }
        }
    }

    protected boolean checkIsSignedBy(CertificateToken token) {
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getName());
    }

    public CRLValidity getCrlValidity() {
        return this.crlValidity;
    }

    public X500Principal getIssuerX500Principal() {
        if (this.crlValidity.getIssuerToken() != null) {
            return this.crlValidity.getIssuerToken().getSubjectX500Principal();
        }
        return null;
    }

    public String getAbbreviation() {
        return "CRLToken[" + (this.productionDate == null ? "?" : DSSUtils.formatInternal(this.productionDate)) + ", signedBy=" + this.getIssuerX500Principal() + "]";
    }

    public byte[] getEncoded() {
        return this.crlValidity.getCrlEncoded();
    }

    public InputStream getCRLStream() {
        return this.crlValidity.getCrlInputStream();
    }

    public boolean isValid() {
        return this.crlValidity.isValid();
    }

    public String toString(String indentStr) {
        StringBuilder out = new StringBuilder();
        out.append(indentStr).append("CRLToken[\n");
        indentStr = indentStr + "\t";
        out.append(indentStr).append("Production time: ").append(this.productionDate == null ? "?" : DSSUtils.formatInternal(this.productionDate)).append('\n');
        out.append(indentStr).append("Signature algorithm: ").append((Object)(this.signatureAlgorithm == null ? "?" : this.signatureAlgorithm)).append('\n');
        out.append(indentStr).append("Status: ").append(this.getStatus()).append('\n');
        out.append(indentStr).append("Issuer's certificate: ").append(this.getIssuerX500Principal()).append('\n');
        indentStr = indentStr.substring(1);
        out.append(indentStr).append(']');
        return out.toString();
    }
}

