/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.x509.crl;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.x509.crl.OfflineCRLSource;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalResourcesCRLSource
extends OfflineCRLSource {
    private static final long serialVersionUID = -985602836642741439L;
    private static final Logger LOG = LoggerFactory.getLogger(ExternalResourcesCRLSource.class);

    public ExternalResourcesCRLSource(String ... paths) {
        for (String pathItem : paths) {
            try {
                this.addCRLToken(this.getClass().getResourceAsStream(pathItem));
            }
            catch (Exception e) {
                LOG.error("Unable to load '" + pathItem + "'", (Throwable)e);
            }
        }
    }

    public ExternalResourcesCRLSource(InputStream ... inputStreams) {
        for (InputStream inputStream : inputStreams) {
            this.addCRLToken(inputStream);
        }
    }

    private void addCRLToken(InputStream inputStream) {
        try (InputStream is = inputStream;){
            this.addCRLBinary(Utils.toByteArray((InputStream)is));
        }
        catch (IOException e) {
            throw new DSSException((Throwable)e);
        }
    }
}

