/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.x509.crl;

import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.crl.CRLUtils;
import eu.europa.esig.dss.crl.CRLValidity;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.RevocationOrigin;
import eu.europa.esig.dss.x509.crl.CRLSource;
import eu.europa.esig.dss.x509.crl.CRLToken;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OfflineCRLSource
implements CRLSource {
    private static final Logger LOG = LoggerFactory.getLogger(OfflineCRLSource.class);
    protected Map<String, byte[]> crlsMap = new HashMap<String, byte[]>();
    private Map<String, CRLValidity> crlValidityMap = new HashMap<String, CRLValidity>();
    private Map<CertificateToken, CRLToken> validCRLTokenList = new HashMap<CertificateToken, CRLToken>();

    @Override
    public final CRLToken getRevocationToken(CertificateToken certificateToken, CertificateToken issuerToken) {
        if (certificateToken == null) {
            throw new NullPointerException();
        }
        CRLToken validCRLToken = this.validCRLTokenList.get(certificateToken);
        if (validCRLToken != null) {
            validCRLToken.setOrigin(RevocationOrigin.SIGNATURE);
            return validCRLToken;
        }
        if (issuerToken == null) {
            return null;
        }
        CRLValidity bestCRLValidity = this.getBestCrlValidity(certificateToken, issuerToken);
        if (bestCRLValidity == null) {
            return null;
        }
        CRLToken crlToken = new CRLToken(certificateToken, bestCRLValidity);
        crlToken.setOrigin(RevocationOrigin.SIGNATURE);
        this.validCRLTokenList.put(certificateToken, crlToken);
        return crlToken;
    }

    private CRLValidity getBestCrlValidity(CertificateToken certificateToken, CertificateToken issuerToken) {
        CRLValidity bestCRLValidity = null;
        Date bestX509UpdateDate = null;
        for (Map.Entry<String, byte[]> crlEntry : this.crlsMap.entrySet()) {
            boolean periodAreIntersecting;
            CRLValidity crlValidity = this.getCrlValidity(crlEntry.getKey(), crlEntry.getValue(), issuerToken);
            if (crlValidity == null || !crlValidity.isValid() || !issuerToken.getPublicKey().equals(crlValidity.getIssuerToken().getPublicKey())) continue;
            Date thisUpdate = crlValidity.getThisUpdate();
            Date nextUpdate = crlValidity.getNextUpdate();
            Date notAfter = certificateToken.getNotAfter();
            Date notBefore = certificateToken.getNotBefore();
            boolean bl = periodAreIntersecting = thisUpdate.before(notAfter) && nextUpdate != null && nextUpdate.after(notBefore);
            if (!periodAreIntersecting) {
                LOG.warn("The CRL was not issued during the validity period of the certificate! Certificate: {}", (Object)certificateToken.getDSSIdAsString());
                continue;
            }
            if (bestX509UpdateDate != null && !thisUpdate.after(bestX509UpdateDate)) continue;
            bestCRLValidity = crlValidity;
            bestX509UpdateDate = thisUpdate;
        }
        return bestCRLValidity;
    }

    private synchronized CRLValidity getCrlValidity(String key, byte[] crlBinaries, CertificateToken issuerToken) {
        CRLValidity crlValidity = this.crlValidityMap.get(key);
        if (crlValidity == null) {
            try (ByteArrayInputStream is = new ByteArrayInputStream(crlBinaries);){
                crlValidity = CRLUtils.isValidCRL((InputStream)is, (CertificateToken)issuerToken);
                if (crlValidity.isValid()) {
                    this.crlValidityMap.put(key, crlValidity);
                }
            }
            catch (IOException e) {
                LOG.error("Unable to parse CRL", (Throwable)e);
            }
        }
        return crlValidity;
    }

    public Collection<byte[]> getContainedX509CRLs() {
        return Collections.unmodifiableCollection(this.crlsMap.values());
    }

    protected void addCRLBinary(byte[] binaries) {
        String base64Digest = Utils.toBase64((byte[])DSSUtils.digest(DigestAlgorithm.SHA256, binaries));
        this.addCRLBinary(base64Digest, binaries);
    }

    protected void addCRLBinary(String base64Digest, byte[] binaries) {
        if (!this.crlsMap.containsKey(base64Digest) && !this.crlValidityMap.containsKey(base64Digest)) {
            this.crlsMap.put(base64Digest, binaries);
        }
    }
}

