/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.x509.ocsp;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.x509.ocsp.OfflineOCSPSource;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPResp;

public class ExternalResourcesOCSPSource
extends OfflineOCSPSource {
    protected List<BasicOCSPResp> ocspResponses = new ArrayList<BasicOCSPResp>();

    public ExternalResourcesOCSPSource(String ... paths) {
        for (String pathItem : paths) {
            this.load(this.getClass().getResourceAsStream(pathItem));
        }
    }

    public ExternalResourcesOCSPSource(InputStream ... inputStreams) {
        for (InputStream inputStream : inputStreams) {
            this.load(inputStream);
        }
    }

    private void load(InputStream inputStream) {
        try (InputStream is = inputStream;){
            OCSPResp ocspResp = new OCSPResp(is);
            BasicOCSPResp basicOCSPResp = (BasicOCSPResp)ocspResp.getResponseObject();
            this.ocspResponses.add(basicOCSPResp);
        }
        catch (Exception e) {
            throw new DSSException((Throwable)e);
        }
    }

    @Override
    public List<BasicOCSPResp> getContainedOCSPResponses() {
        return this.ocspResponses;
    }
}

