/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.x509.ocsp;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSRevocationUtils;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.Digest;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.SignatureAlgorithm;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.RevocationToken;
import eu.europa.esig.dss.x509.crl.CRLReasonEnum;
import eu.europa.esig.dss.x509.ocsp.OCSPRespStatus;
import java.io.IOException;
import java.io.StringWriter;
import java.text.ParseException;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.isismtt.ISISMTTObjectIdentifiers;
import org.bouncycastle.asn1.isismtt.ocsp.CertHash;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.cert.ocsp.UnknownStatus;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCSPToken
extends RevocationToken {
    private static final Logger LOG = LoggerFactory.getLogger(OCSPToken.class);
    private CertificateID certId;
    private X500Principal issuerX500Principal;
    private OCSPRespStatus responseStatus;
    private boolean useNonce;
    private boolean nonceMatch;
    private BasicOCSPResp basicOCSPResp;

    public void extractInfo() {
        if (this.basicOCSPResp != null) {
            this.productionDate = this.basicOCSPResp.getProducedAt();
            this.signatureAlgorithm = SignatureAlgorithm.forOID((String)this.basicOCSPResp.getSignatureAlgOID().getId());
            SingleResp bestSingleResp = this.getBestSingleResp(this.basicOCSPResp, this.certId);
            if (bestSingleResp != null) {
                this.thisUpdate = bestSingleResp.getThisUpdate();
                this.nextUpdate = bestSingleResp.getNextUpdate();
                this.extractStatusInfo(bestSingleResp);
                this.extractArchiveCutOff(bestSingleResp);
                this.extractCertHashExtension(bestSingleResp);
            }
        }
    }

    private SingleResp getBestSingleResp(BasicOCSPResp basicOCSPResp, CertificateID certId) {
        SingleResp[] responses;
        Date bestUpdate = null;
        SingleResp bestSingleResp = null;
        for (SingleResp singleResp : responses = this.getResponses(basicOCSPResp)) {
            if (!DSSRevocationUtils.matches(certId, singleResp)) continue;
            Date thisUpdate = singleResp.getThisUpdate();
            if (bestUpdate != null && !thisUpdate.after(bestUpdate)) continue;
            bestSingleResp = singleResp;
            bestUpdate = thisUpdate;
        }
        return bestSingleResp;
    }

    private SingleResp[] getResponses(BasicOCSPResp basicOCSPResp) {
        SingleResp[] responses = new SingleResp[]{};
        try {
            responses = basicOCSPResp.getResponses();
        }
        catch (Exception e) {
            LOG.error("Unable to parse the responses object from OCSP", (Throwable)e);
        }
        return responses;
    }

    private void extractStatusInfo(SingleResp bestSingleResp) {
        CertificateStatus certStatus = bestSingleResp.getCertStatus();
        if (CertificateStatus.GOOD == certStatus) {
            if (LOG.isInfoEnabled()) {
                LOG.info("OCSP status is good");
            }
            this.status = true;
        } else if (certStatus instanceof RevokedStatus) {
            if (LOG.isInfoEnabled()) {
                LOG.info("OCSP status revoked");
            }
            RevokedStatus revokedStatus = (RevokedStatus)certStatus;
            this.status = false;
            this.revocationDate = revokedStatus.getRevocationTime();
            int reasonId = 0;
            if (revokedStatus.hasRevocationReason()) {
                reasonId = revokedStatus.getRevocationReason();
            }
            this.reason = CRLReasonEnum.fromInt((int)reasonId);
        } else if (certStatus instanceof UnknownStatus) {
            if (LOG.isInfoEnabled()) {
                LOG.info("OCSP status unknown");
            }
            this.reason = CRLReasonEnum.unknow;
        } else {
            LOG.info("OCSP certificate status: {}", (Object)certStatus);
        }
    }

    private void extractArchiveCutOff(SingleResp bestSingleResp) {
        Extension extension = bestSingleResp.getExtension(OCSPObjectIdentifiers.id_pkix_ocsp_archive_cutoff);
        if (extension != null) {
            ASN1GeneralizedTime archiveCutOffAsn1 = (ASN1GeneralizedTime)extension.getParsedValue();
            try {
                this.archiveCutOff = archiveCutOffAsn1.getDate();
            }
            catch (ParseException e) {
                LOG.warn("Unable to extract id_pkix_ocsp_archive_cutoff : " + e.getMessage());
            }
        }
    }

    private void extractCertHashExtension(SingleResp bestSingleResp) {
        Extension extension = bestSingleResp.getExtension(ISISMTTObjectIdentifiers.id_isismtt_at_certHash);
        if (extension != null) {
            try {
                CertHash asn1CertHash = CertHash.getInstance((Object)extension.getParsedValue());
                DigestAlgorithm digestAlgo = DigestAlgorithm.forOID((String)asn1CertHash.getHashAlgorithm().getAlgorithm().getId());
                this.certHash = new Digest(digestAlgo, asn1CertHash.getCertificateHash());
            }
            catch (Exception e) {
                LOG.warn("Unable to extract id_isismtt_at_certHash : " + e.getMessage());
            }
        }
    }

    protected boolean checkIsSignedBy(CertificateToken candidate) {
        if (this.basicOCSPResp == null) {
            return false;
        }
        try {
            this.signatureInvalidityReason = "";
            JcaContentVerifierProviderBuilder jcaContentVerifierProviderBuilder = new JcaContentVerifierProviderBuilder();
            jcaContentVerifierProviderBuilder.setProvider("BC");
            ContentVerifierProvider contentVerifierProvider = jcaContentVerifierProviderBuilder.build(candidate.getPublicKey());
            this.signatureValid = this.basicOCSPResp.isSignatureValid(contentVerifierProvider);
        }
        catch (Exception e) {
            this.signatureInvalidityReason = e.getClass().getSimpleName() + " - " + e.getMessage();
            this.signatureValid = false;
        }
        return this.signatureValid;
    }

    public OCSPRespStatus getResponseStatus() {
        return this.responseStatus;
    }

    public void setResponseStatus(OCSPRespStatus responseStatus) {
        this.responseStatus = responseStatus;
    }

    public boolean isUseNonce() {
        return this.useNonce;
    }

    public void setUseNonce(boolean useNonce) {
        this.useNonce = useNonce;
    }

    public boolean isNonceMatch() {
        return this.nonceMatch;
    }

    public void setNonceMatch(boolean nonceMatch) {
        this.nonceMatch = nonceMatch;
    }

    public BasicOCSPResp getBasicOCSPResp() {
        return this.basicOCSPResp;
    }

    public void setBasicOCSPResp(BasicOCSPResp basicOCSPResp) {
        this.basicOCSPResp = basicOCSPResp;
    }

    public CertificateID getCertId() {
        return this.certId;
    }

    public void setCertId(CertificateID certId) {
        this.certId = certId;
    }

    public boolean isValid() {
        return this.signatureValid;
    }

    public String getAbbreviation() {
        return "OCSPToken[" + (this.basicOCSPResp == null ? "?" : DSSUtils.formatInternal(this.basicOCSPResp.getProducedAt())) + ", signedBy=" + this.getIssuerX500Principal() + "]";
    }

    public String toString(String indentStr) {
        StringWriter out = new StringWriter();
        out.append(indentStr).append("OCSPToken[");
        out.append("ProductionTime: ").append(DSSUtils.formatInternal(this.productionDate)).append("; ");
        out.append("ThisUpdate: ").append(DSSUtils.formatInternal(this.thisUpdate)).append("; ");
        out.append("NextUpdate: ").append(DSSUtils.formatInternal(this.nextUpdate)).append('\n');
        out.append("SignedBy: ").append(this.getIssuerX500Principal().toString()).append('\n');
        indentStr = indentStr + "\t";
        out.append(indentStr).append("Signature algorithm: ").append(this.signatureAlgorithm == null ? "?" : this.signatureAlgorithm.getJCEId()).append('\n');
        indentStr = indentStr.substring(1);
        out.append(indentStr).append("]");
        return out.toString();
    }

    public byte[] getEncoded() {
        try {
            if (this.basicOCSPResp != null) {
                OCSPResp ocspResp = DSSRevocationUtils.fromBasicToResp(this.basicOCSPResp);
                return ocspResp.getEncoded();
            }
            throw new DSSException("Empty OCSP response");
        }
        catch (IOException e) {
            throw new DSSException("OCSP encoding error: " + e.getMessage(), (Throwable)e);
        }
    }

    public void setIssuerX500Principal(X500Principal issuerX500Principal) {
        this.issuerX500Principal = issuerX500Principal;
    }

    public X500Principal getIssuerX500Principal() {
        return this.issuerX500Principal;
    }
}

