/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.ObjectIdentifier;
import eu.europa.esig.dss.enumerations.X520Attributes;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.identifier.TokenIdentifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSSecurityProvider;
import eu.europa.esig.dss.spi.client.http.DataLoader;
import eu.europa.esig.dss.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHAKEDigest;
import org.bouncycastle.crypto.io.DigestOutputStream;
import org.bouncycastle.openssl.jcajce.JcaMiscPEMGenerator;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemReader;
import org.bouncycastle.util.io.pem.PemWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DSSUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DSSUtils.class);
    public static final byte[] EMPTY_BYTE_ARRAY;
    private static final String DEFAULT_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final String OID_NAMESPACE_PREFIX = "urn:oid:";

    private DSSUtils() {
    }

    public static String formatInternal(Date date) {
        return DSSUtils.formatDateWithCustomFormat(date, DEFAULT_DATE_TIME_FORMAT);
    }

    public static String formatDateWithCustomFormat(Date date, String format) {
        return DSSUtils.formatDateWithCustomFormat(date, format, null);
    }

    public static String formatDateToRFC(Date date) {
        return DSSUtils.formatDateWithCustomFormat(date, DEFAULT_DATE_TIME_FORMAT, "UTC");
    }

    public static String formatDateWithCustomFormat(Date date, String format, String timeZone) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        if (Utils.isStringNotEmpty((String)timeZone)) {
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        return date == null ? "N/A" : simpleDateFormat.format(date);
    }

    public static String toHex(byte[] value) {
        return value != null ? Utils.toHex((byte[])value) : null;
    }

    public static String convertToPEM(CertificateToken cert) {
        return DSSUtils.convertToPEM(cert.getCertificate());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String convertToPEM(Object obj) {
        try (StringWriter out = new StringWriter();){
            String string;
            try (PemWriter pemWriter = new PemWriter((Writer)out);){
                pemWriter.writeObject((PemObjectGenerator)new JcaMiscPEMGenerator(obj));
                pemWriter.flush();
                string = out.toString();
            }
            return string;
        }
        catch (Exception e) {
            throw new DSSException("Unable to convert DER to PEM", (Throwable)e);
        }
    }

    public static boolean isStartWithASN1SequenceTag(InputStream is) {
        byte firstByte = DSSUtils.readFirstByte((DSSDocument)new InMemoryDocument(is));
        return DSSASN1Utils.isASN1SequenceTag(firstByte);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] convertToDER(String pemContent) {
        try (StringReader reader = new StringReader(pemContent);){
            byte[] byArray;
            try (PemReader pemReader = new PemReader((Reader)reader);){
                PemObject readPemObject = pemReader.readPemObject();
                byArray = readPemObject.getContent();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new DSSException("Unable to convert PEM to DER", (Throwable)e);
        }
    }

    public static CertificateToken loadCertificate(File file) {
        InputStream inputStream = DSSUtils.toByteArrayInputStream(file);
        return DSSUtils.loadCertificate(inputStream);
    }

    public static CertificateToken loadCertificate(InputStream inputStream) {
        List<CertificateToken> certificates = DSSUtils.loadCertificates(inputStream);
        if (certificates.size() == 1) {
            return certificates.get(0);
        }
        throw new DSSException("Could not parse certificate");
    }

    public static Collection<CertificateToken> loadCertificateFromP7c(InputStream is) {
        return DSSUtils.loadCertificates(is);
    }

    private static List<CertificateToken> loadCertificates(InputStream is) {
        ArrayList<CertificateToken> certificates = new ArrayList<CertificateToken>();
        try {
            Collection<? extends Certificate> certificatesCollection = CertificateFactory.getInstance("X.509", DSSSecurityProvider.getSecurityProviderName()).generateCertificates(is);
            if (certificatesCollection != null) {
                for (X509Certificate x509Certificate : certificatesCollection) {
                    certificates.add(new CertificateToken(x509Certificate));
                }
            }
            if (certificates.isEmpty()) {
                throw new DSSException("No certificate found in the InputStream");
            }
            return certificates;
        }
        catch (DSSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DSSException("Unable to load certificate(s) : " + e.getMessage(), (Throwable)e);
        }
    }

    public static CertificateToken loadCertificate(byte[] input) {
        CertificateToken certificateToken;
        Objects.requireNonNull(input, "Input binary cannot be null");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(input);
        try {
            certificateToken = DSSUtils.loadCertificate(inputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException((Throwable)e);
            }
        }
        inputStream.close();
        return certificateToken;
    }

    public static CertificateToken loadCertificateFromBase64EncodedString(String base64Encoded) {
        byte[] bytes = Utils.fromBase64((String)base64Encoded);
        return DSSUtils.loadCertificate(bytes);
    }

    public static Collection<CertificateToken> loadPotentialIssuerCertificates(CertificateToken cert, DataLoader loader) {
        List<String> urls = DSSASN1Utils.getCAAccessLocations(cert);
        if (Utils.isCollectionEmpty(urls)) {
            LOG.info("There is no AIA extension for certificate download.");
            return Collections.emptyList();
        }
        if (loader == null) {
            LOG.warn("There is no DataLoader defined to load Certificates from AIA extension (urls : {})", urls);
            return Collections.emptyList();
        }
        for (String url : urls) {
            LOG.debug("Loading certificate(s) from {}", (Object)url);
            byte[] bytes = null;
            try {
                bytes = loader.get(url);
            }
            catch (Exception e) {
                LOG.warn("Unable to download certificate from '{}': {}", (Object)url, (Object)e.getMessage());
                continue;
            }
            if (Utils.isArrayNotEmpty((byte[])bytes)) {
                List<CertificateToken> list;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Base64 content : {}", (Object)Utils.toBase64((byte[])bytes));
                }
                ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                try {
                    list = DSSUtils.loadCertificates(is);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        LOG.warn("Unable to parse certificate(s) from AIA (url: {}) : {}", (Object)url, (Object)e.getMessage());
                    }
                }
                ((InputStream)is).close();
                return list;
                continue;
            }
            LOG.warn("Empty content from {}.", (Object)url);
        }
        return Collections.emptyList();
    }

    public static String getSHA1Digest(String stringToDigest) {
        return Utils.toHex((byte[])DSSUtils.digest(DigestAlgorithm.SHA1, stringToDigest.getBytes(StandardCharsets.UTF_8)));
    }

    public static boolean isSHA1Digest(String str) {
        return Utils.isStringNotBlank((String)str) && Utils.isHexEncoded((String)str) && str.length() == 40;
    }

    public static byte[] digest(DigestAlgorithm digestAlgorithm, byte[] data) {
        Objects.requireNonNull(data, "The data cannot be null");
        switch (digestAlgorithm) {
            case SHAKE128: {
                return DSSUtils.computeDigest((Digest)new SHAKEDigest(128), data);
            }
            case SHAKE256: {
                return DSSUtils.computeDigest((Digest)new SHAKEDigest(256), data);
            }
        }
        MessageDigest messageDigest = DSSUtils.getMessageDigest(digestAlgorithm);
        return messageDigest.digest(data);
    }

    private static byte[] computeDigest(Digest digest, byte[] data) {
        byte[] byArray;
        DigestOutputStream dos = new DigestOutputStream(digest);
        try {
            dos.write(data);
            byArray = dos.getDigest();
        }
        catch (Throwable throwable) {
            try {
                try {
                    dos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException("Unable to compute digest : " + e.getMessage(), (Throwable)e);
            }
        }
        dos.close();
        return byArray;
    }

    public static MessageDigest getMessageDigest(DigestAlgorithm digestAlgorithm) {
        Objects.requireNonNull(digestAlgorithm, "The DigestAlgorithm cannot be null");
        try {
            return digestAlgorithm.getMessageDigest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new DSSException("Unable to create a MessageDigest for algorithm " + digestAlgorithm, (Throwable)e);
        }
    }

    public static byte[] encodeRSADigest(DigestAlgorithm digestAlgorithm, byte[] digest) {
        try {
            AlgorithmIdentifier algId = new AlgorithmIdentifier(new ASN1ObjectIdentifier(digestAlgorithm.getOid()), (ASN1Encodable)DERNull.INSTANCE);
            DigestInfo digestInfo = new DigestInfo(algId, digest);
            return digestInfo.getEncoded("DER");
        }
        catch (IOException e) {
            throw new DSSException("Unable to encode digest", (Throwable)e);
        }
    }

    public static byte[] digest(DigestAlgorithm digestAlgo, InputStream inputStream) {
        try {
            MessageDigest messageDigest = DSSUtils.getMessageDigest(digestAlgo);
            byte[] buffer = new byte[4096];
            int count = 0;
            while ((count = inputStream.read(buffer)) > 0) {
                messageDigest.update(buffer, 0, count);
            }
            return messageDigest.digest();
        }
        catch (IOException e) {
            throw new DSSException((Throwable)e);
        }
    }

    public static byte[] digest(DigestAlgorithm digestAlgorithm, DSSDocument document) {
        byte[] byArray;
        block8: {
            InputStream is = document.openStream();
            try {
                byArray = DSSUtils.digest(digestAlgorithm, is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new DSSException((Throwable)e);
                }
            }
            is.close();
        }
        return byArray;
    }

    public static byte[] digest(DigestAlgorithm digestAlgorithm, byte[] ... data) {
        MessageDigest messageDigest = DSSUtils.getMessageDigest(digestAlgorithm);
        for (byte[] bytes : data) {
            messageDigest.update(bytes);
        }
        return messageDigest.digest();
    }

    public static InputStream toInputStream(File file) {
        Objects.requireNonNull(file, "The file cannot be null");
        try {
            return DSSUtils.openInputStream(file);
        }
        catch (IOException e) {
            throw new DSSException((Throwable)e);
        }
    }

    public static InputStream toByteArrayInputStream(File file) {
        return new ByteArrayInputStream(DSSUtils.toByteArray(file));
    }

    public static byte[] toByteArray(File file) {
        byte[] byArray;
        block8: {
            InputStream is = DSSUtils.openInputStream(file);
            try {
                byArray = DSSUtils.toByteArray(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new DSSException((Throwable)e);
                }
            }
            is.close();
        }
        return byArray;
    }

    /*
     * Exception decompiling
     */
    public static DSSDocument splitDocument(DSSDocument origin, int start, int end) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static InputStream openInputStream(File file) throws IOException {
        Objects.requireNonNull(file, "The file cannot be null");
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canRead()) {
                throw new IOException("File '" + file + "' cannot be read");
            }
        } else {
            throw new FileNotFoundException("File '" + file + "' does not exist");
        }
        return new FileInputStream(file);
    }

    public static byte[] toByteArray(DSSDocument document) {
        byte[] byArray;
        block8: {
            InputStream is = document.openStream();
            try {
                byArray = DSSUtils.toByteArray(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new DSSException((Throwable)e);
                }
            }
            is.close();
        }
        return byArray;
    }

    public static byte[] toByteArray(InputStream inputStream) {
        Objects.requireNonNull(inputStream, "The InputStream cannot be null");
        try {
            return Utils.toByteArray((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new DSSException((Throwable)e);
        }
    }

    public static CMSSignedData toCMSSignedData(DSSDocument document) {
        CMSSignedData cMSSignedData;
        block8: {
            InputStream inputStream = document.openStream();
            try {
                cMSSignedData = new CMSSignedData(inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | CMSException e) {
                    throw new DSSException("Not a valid CAdES file", e);
                }
            }
            inputStream.close();
        }
        return cMSSignedData;
    }

    public static boolean isTimestampToken(DSSDocument document) {
        TimeStampToken timeStampToken = null;
        try {
            CMSSignedData cmsSignedData = DSSUtils.toCMSSignedData(document);
            timeStampToken = new TimeStampToken(cmsSignedData);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return timeStampToken != null;
    }

    public static long getFileByteSize(DSSDocument dssDocument) {
        long l;
        block8: {
            InputStream is = dssDocument.openStream();
            try {
                l = Utils.getInputStreamSize((InputStream)is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new DSSException(String.format("Cannot read the document with name [%s]", dssDocument.getName()), (Throwable)e);
                }
            }
            is.close();
        }
        return l;
    }

    public static void saveToFile(byte[] bytes, File file) {
        file.getParentFile().mkdirs();
        try (ByteArrayInputStream is = new ByteArrayInputStream(bytes);
             FileOutputStream os = new FileOutputStream(file);){
            Utils.copy((InputStream)is, (OutputStream)os);
        }
        catch (IOException e) {
            throw new DSSException((Throwable)e);
        }
    }

    public static String getNormalizedString(String str) {
        String normalizedStr = str;
        try {
            normalizedStr = URLDecoder.decode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.debug("Cannot decode fileName [{}]. Reason : {}", (Object)str, (Object)e.getMessage());
        }
        normalizedStr = normalizedStr.replaceAll("\\W", "_");
        return normalizedStr;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String getDeterministicId(Date signingTime, TokenIdentifier id) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            String string;
            try (DataOutputStream dos = new DataOutputStream(baos);){
                if (signingTime != null) {
                    dos.writeLong(signingTime.getTime());
                }
                if (id != null) {
                    dos.writeChars(id.asXmlId());
                }
                dos.flush();
                string = "id-" + DSSUtils.getMD5Digest(baos.toByteArray());
            }
            return string;
        }
        catch (IOException e) {
            throw new DSSException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String getCounterSignatureDeterministicId(Date signingTime, TokenIdentifier id, String masterSignatureId) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            String string;
            try (DataOutputStream dos = new DataOutputStream(baos);){
                if (signingTime != null) {
                    dos.writeLong(signingTime.getTime());
                }
                if (id != null) {
                    dos.writeChars(id.asXmlId());
                }
                if (masterSignatureId != null) {
                    dos.writeChars(masterSignatureId);
                }
                dos.flush();
                string = "id-" + DSSUtils.getMD5Digest(baos.toByteArray());
            }
            return string;
        }
        catch (IOException e) {
            throw new DSSException((Throwable)e);
        }
    }

    public static String getMD5Digest(byte[] bytes) {
        return Utils.toHex((byte[])DSSUtils.digest(DigestAlgorithm.MD5, bytes));
    }

    public static X500Principal getX500PrincipalOrNull(String x500PrincipalString) {
        try {
            return new X500Principal(x500PrincipalString, X520Attributes.getUppercaseDescriptionForOids());
        }
        catch (Exception e) {
            LOG.warn("Unable to create an instance of X500Principal : {}", (Object)e.getMessage());
            return null;
        }
    }

    public static Date getUtcDate(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.set(year, month, day, 0, 0, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static void printSecurityProviders() {
        Provider[] providers;
        for (Provider provider : providers = Security.getProviders()) {
            LOG.info("PROVIDER: {}", (Object)provider.getName());
            Set<Provider.Service> services = provider.getServices();
            for (Provider.Service service : services) {
                LOG.info("\tALGORITHM: {} / {} / {}", new Object[]{service.getAlgorithm(), service.getType(), service.getClassName()});
            }
        }
    }

    public static byte readFirstByte(DSSDocument dssDocument) {
        byte[] result = new byte[1];
        try (InputStream inputStream = dssDocument.openStream();){
            inputStream.read(result, 0, 1);
        }
        catch (IOException e) {
            throw new DSSException(String.format("Cannot read first byte of the document. Reason : %s", e.getMessage()), (Throwable)e);
        }
        return result[0];
    }

    public static boolean compareFirstBytes(DSSDocument dssDocument, byte[] byteArray) {
        try {
            byte[] preamble = new byte[byteArray.length];
            DSSUtils.readAvailableBytes(dssDocument, preamble);
            return Arrays.equals(byteArray, preamble);
        }
        catch (IllegalStateException e) {
            LOG.warn("Cannot compare first bytes of the document. Reason : {}", (Object)e.getMessage());
            return false;
        }
    }

    public static byte[] concatenate(byte[] ... arrays) {
        if (arrays == null || arrays.length == 0 || arrays.length == 1 && arrays[0] == null) {
            return null;
        }
        if (arrays.length == 1) {
            return (byte[])arrays[0].clone();
        }
        int joinedLength = 0;
        for (byte[] array : arrays) {
            if (array == null) continue;
            joinedLength += array.length;
        }
        byte[] joinedArray = new byte[joinedLength];
        int destinationIndex = 0;
        for (byte[] array : arrays) {
            if (array == null) continue;
            System.arraycopy(array, 0, joinedArray, destinationIndex, array.length);
            destinationIndex += array.length;
        }
        return joinedArray;
    }

    public static String decodeUrl(String uri) {
        try {
            return URLDecoder.decode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Unable to decode '{}' : {}", new Object[]{uri, e.getMessage(), e});
            return uri;
        }
    }

    public static long skipAvailableBytes(InputStream is, long n) throws IllegalStateException {
        try {
            long skipped = is.skip(n);
            if (skipped != n) {
                throw new IllegalStateException(String.format("The number of skipped bytes [%s] differs from the expected value [%s]! The InputStream is too small, corrupted or not accessible!", skipped, n));
            }
            return skipped;
        }
        catch (IOException e) {
            throw new DSSException("Cannot read the InputStream!", (Throwable)e);
        }
    }

    public static long readAvailableBytes(DSSDocument dssDocument, byte[] b) throws IllegalStateException {
        long l;
        block8: {
            InputStream is = dssDocument.openStream();
            try {
                l = DSSUtils.readAvailableBytes(is, b);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new DSSException("Cannot read a sequence of bytes from the document.", (Throwable)e);
                }
            }
            is.close();
        }
        return l;
    }

    public static long readAvailableBytes(InputStream is, byte[] b) throws IllegalStateException {
        return DSSUtils.readAvailableBytes(is, b, 0, b.length);
    }

    public static long readAvailableBytes(InputStream is, byte[] b, int off, int len) throws IllegalStateException {
        try {
            long read = is.read(b, off, len);
            if (read != (long)len) {
                throw new IllegalStateException(String.format("The number of read bytes [%s] differs from the expected value [%s]! The InputStream is too small, corrupted or not accessible!", read, len));
            }
            return read;
        }
        catch (IOException e) {
            throw new DSSException("Cannot read the InputStream!", (Throwable)e);
        }
    }

    public static String encodeURI(String fileURI) {
        String[] uriParts;
        StringBuilder sb = new StringBuilder();
        String uriDelimiter = "";
        for (String part : uriParts = fileURI.split("/")) {
            sb.append(uriDelimiter);
            sb.append(DSSUtils.encodePartURI(part));
            uriDelimiter = "/";
        }
        return sb.toString();
    }

    private static String encodePartURI(String uriPart) {
        try {
            return URLEncoder.encode(uriPart, "UTF-8").replace("+", "%20");
        }
        catch (Exception e) {
            LOG.warn("Unable to encode uri '{}' : {}", (Object)uriPart, (Object)e.getMessage());
            return uriPart;
        }
    }

    public static String getExceptionMessage(Exception e) {
        if (e == null) {
            throw new DSSException("Cannot retrieve a message. The exception is null!");
        }
        if (e.getMessage() != null) {
            return e.getMessage();
        }
        if (e.getCause() != null && e.getCause().getMessage() != null) {
            return e.getCause().getMessage();
        }
        return e.getClass().getName();
    }

    public static eu.europa.esig.dss.model.Digest getDigest(DigestAlgorithm digestAlgo, DSSDocument dssDocument) {
        return new eu.europa.esig.dss.model.Digest(digestAlgo, DSSUtils.digest(digestAlgo, dssDocument));
    }

    public static String removeControlCharacters(String str) {
        if (str != null) {
            String cleanedString = str.replaceAll("[^\\P{Cntrl}]", "");
            if (!str.equals(cleanedString)) {
                LOG.warn("The string [{}] contains illegal characters and was replaced to [{}]", (Object)str, (Object)cleanedString);
            }
            return cleanedString;
        }
        return null;
    }

    public static boolean isUrnOid(String id) {
        return id != null && id.matches("^(?i)urn:oid:.*$");
    }

    public static String toUrnOid(String oid) {
        return OID_NAMESPACE_PREFIX + oid;
    }

    public static boolean isOidCode(String oid) {
        return oid != null && oid.matches("^([0-2])((\\.0)|(\\.[1-9][0-9]*))*$");
    }

    public static String getOidCode(String urnOid) {
        if (urnOid == null) {
            return null;
        }
        return urnOid.substring(urnOid.lastIndexOf(58) + 1);
    }

    public static String getUriOrUrnOid(ObjectIdentifier objectIdentifier) {
        String uri = objectIdentifier.getUri();
        if (uri == null && objectIdentifier.getOid() != null) {
            uri = DSSUtils.toUrnOid(objectIdentifier.getOid());
        }
        return uri;
    }

    public static String getObjectIdentifier(String oidOrUriString) {
        String policyIdString = oidOrUriString;
        if (Utils.isStringNotEmpty((String)oidOrUriString)) {
            policyIdString = policyIdString.replace("\n", "");
            if (DSSUtils.isUrnOid(policyIdString = Utils.trim((String)policyIdString))) {
                policyIdString = DSSUtils.getOidCode(policyIdString);
            }
        }
        return policyIdString;
    }

    public static String stripFirstLeadingOccurance(String text, String leading) {
        if (text == null) {
            return null;
        }
        if (leading == null) {
            return text;
        }
        return text.replaceFirst("^" + leading, "");
    }

    public static List<String> getDocumentNames(List<DSSDocument> dssDocuments) {
        if (Utils.isCollectionNotEmpty(dssDocuments)) {
            return dssDocuments.stream().map(DSSDocument::getName).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static <T> void enrichCollection(Collection<T> currentCollection, Collection<T> toAddCollection) {
        for (T object : toAddCollection) {
            if (currentCollection.contains(object)) continue;
            currentCollection.add(object);
        }
    }

    static {
        Security.addProvider(DSSSecurityProvider.getSecurityProvider());
        EMPTY_BYTE_ARRAY = new byte[0];
    }
}

