/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509;

import eu.europa.esig.dss.enumerations.CertificateSourceType;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.identifier.EntityIdentifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.X500PrincipalHelper;
import eu.europa.esig.dss.spi.x509.CertificateIdentifier;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.CertificateSourceEntity;
import eu.europa.esig.dss.spi.x509.CertificateTokenRefMatcher;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonCertificateSource
implements CertificateSource {
    private static final long serialVersionUID = -5031898106342793626L;
    private static final Logger LOG = LoggerFactory.getLogger(CommonCertificateSource.class);
    protected final transient CertificateTokenRefMatcher certificateMatcher = new CertificateTokenRefMatcher();
    private Map<EntityIdentifier, CertificateSourceEntity> entriesByPublicKeyHash = new HashMap<EntityIdentifier, CertificateSourceEntity>();
    private Map<String, Set<CertificateToken>> tokensBySubject = new HashMap<String, Set<CertificateToken>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CertificateToken addCertificate(CertificateToken certificateToAdd) {
        Objects.requireNonNull(certificateToAdd, "The certificate must be filled");
        if (LOG.isTraceEnabled()) {
            LOG.trace("Certificate to add: {} | {}", (Object)certificateToAdd.getIssuerX500Principal(), (Object)certificateToAdd.getSerialNumber());
        }
        Map<Object, Object> map = this.entriesByPublicKeyHash;
        synchronized (map) {
            EntityIdentifier entityKey = certificateToAdd.getEntityKey();
            CertificateSourceEntity poolEntity = this.entriesByPublicKeyHash.get(entityKey);
            if (poolEntity == null) {
                LOG.trace("Public key {} is not in the pool", (Object)entityKey);
                poolEntity = new CertificateSourceEntity(certificateToAdd);
                this.entriesByPublicKeyHash.put(entityKey, poolEntity);
            } else {
                LOG.trace("Public key {} is already in the pool", (Object)entityKey);
                poolEntity.addEquivalentCertificate(certificateToAdd);
            }
        }
        map = this.tokensBySubject;
        synchronized (map) {
            String key = certificateToAdd.getSubject().getCanonical();
            this.tokensBySubject.computeIfAbsent(key, k -> new HashSet()).add(certificateToAdd);
        }
        return certificateToAdd;
    }

    protected void reset() {
        this.entriesByPublicKeyHash = new HashMap<EntityIdentifier, CertificateSourceEntity>();
        this.tokensBySubject = new HashMap<String, Set<CertificateToken>>();
    }

    @Override
    public boolean isKnown(CertificateToken token) {
        CertificateSourceEntity poolEntity = this.entriesByPublicKeyHash.get(token.getEntityKey());
        return poolEntity != null;
    }

    @Override
    public List<CertificateToken> getCertificates() {
        ArrayList<CertificateToken> allCertificates = new ArrayList<CertificateToken>();
        for (CertificateSourceEntity entity : this.entriesByPublicKeyHash.values()) {
            allCertificates.addAll(entity.getEquivalentCertificates());
        }
        return Collections.unmodifiableList(allCertificates);
    }

    @Override
    public List<CertificateSourceEntity> getEntities() {
        return new ArrayList<CertificateSourceEntity>(this.entriesByPublicKeyHash.values());
    }

    @Override
    public Set<CertificateToken> getByPublicKey(PublicKey publicKey) {
        CertificateSourceEntity entity = this.entriesByPublicKeyHash.get(new EntityIdentifier(publicKey));
        if (entity != null) {
            return entity.getEquivalentCertificates();
        }
        return Collections.emptySet();
    }

    @Override
    public Set<CertificateToken> getBySki(byte[] ski) {
        for (CertificateSourceEntity entry : this.entriesByPublicKeyHash.values()) {
            if (!Arrays.equals(entry.getSki(), ski)) continue;
            return entry.getEquivalentCertificates();
        }
        return Collections.emptySet();
    }

    @Override
    public Set<CertificateToken> getBySubject(X500PrincipalHelper subject) {
        Set<CertificateToken> tokensSet = this.tokensBySubject.get(subject.getCanonical());
        if (tokensSet != null) {
            return tokensSet;
        }
        return Collections.emptySet();
    }

    @Override
    public Set<CertificateToken> getByCertificateIdentifier(CertificateIdentifier certificateIdentifier) {
        HashSet<CertificateToken> result = new HashSet<CertificateToken>();
        for (CertificateSourceEntity entry : this.entriesByPublicKeyHash.values()) {
            for (CertificateToken certificateToken : entry.getEquivalentCertificates()) {
                if (!certificateIdentifier.isRelatedToCertificate(certificateToken)) continue;
                result.add(certificateToken);
            }
        }
        return result;
    }

    @Override
    public Set<CertificateToken> getByCertificateDigest(Digest digest) {
        HashSet<CertificateToken> result = new HashSet<CertificateToken>();
        for (CertificateSourceEntity entry : this.entriesByPublicKeyHash.values()) {
            for (CertificateToken certificateToken : entry.getEquivalentCertificates()) {
                if (!Arrays.equals(digest.getValue(), certificateToken.getDigest(digest.getAlgorithm()))) continue;
                result.add(certificateToken);
            }
        }
        return result;
    }

    @Override
    public Set<CertificateToken> findTokensFromCertRef(CertificateRef certificateRef) {
        HashSet<CertificateToken> result = new HashSet<CertificateToken>();
        for (CertificateSourceEntity entry : this.entriesByPublicKeyHash.values()) {
            for (CertificateToken certificateToken : entry.getEquivalentCertificates()) {
                if (!this.certificateMatcher.match(certificateToken, certificateRef)) continue;
                result.add(certificateToken);
            }
        }
        return result;
    }

    public int getNumberOfCertificates() {
        return this.getCertificates().size();
    }

    public int getNumberOfEntities() {
        return this.entriesByPublicKeyHash.size();
    }

    @Override
    public CertificateSourceType getCertificateSourceType() {
        return CertificateSourceType.OTHER;
    }

    @Override
    public boolean isTrusted(CertificateToken certificateToken) {
        return false;
    }

    @Override
    public boolean isAllSelfSigned() {
        for (CertificateToken certificate : this.getCertificates()) {
            if (certificate.isSelfSigned()) continue;
            return false;
        }
        return true;
    }
}

