/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509;

import eu.europa.esig.dss.enumerations.CertificateSourceType;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.X500PrincipalHelper;
import eu.europa.esig.dss.spi.x509.CertificateIdentifier;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.CertificateSourceEntity;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ListCertificateSource {
    private List<CertificateSource> sources = new ArrayList<CertificateSource>();

    public ListCertificateSource() {
    }

    public ListCertificateSource(CertificateSource certificateSource) {
        this.add(certificateSource);
    }

    public ListCertificateSource(List<CertificateSource> certificateSources) {
        this.addAll(certificateSources);
    }

    public void addAll(ListCertificateSource listCertificateSource) {
        if (listCertificateSource != null) {
            this.addAll(listCertificateSource.getSources());
        }
    }

    public void addAll(List<CertificateSource> certificateSources) {
        if (certificateSources != null) {
            for (CertificateSource certificateSource : certificateSources) {
                this.add(certificateSource);
            }
        }
    }

    public void add(CertificateSource certificateSource) {
        if (certificateSource != null) {
            this.sources.add(certificateSource);
        }
    }

    public List<CertificateSource> getSources() {
        return Collections.unmodifiableList(this.sources);
    }

    public Set<CertificateToken> getAllCertificateTokens() {
        HashSet<CertificateToken> allTokens = new HashSet<CertificateToken>();
        for (CertificateSource certificateSource : this.sources) {
            allTokens.addAll(certificateSource.getCertificates());
        }
        return allTokens;
    }

    public Set<CertificateSourceEntity> getAllEntities() {
        HashSet<CertificateSourceEntity> allEntities = new HashSet<CertificateSourceEntity>();
        for (CertificateSource certificateSource : this.sources) {
            allEntities.addAll(certificateSource.getEntities());
        }
        return allEntities;
    }

    public boolean isEmpty() {
        return this.sources.isEmpty();
    }

    public boolean areAllCertSourcesTrusted() {
        for (CertificateSource certificateSource : this.sources) {
            if (certificateSource.getCertificateSourceType().isTrusted()) continue;
            return false;
        }
        return true;
    }

    public boolean isTrusted(CertificateToken certificateToken) {
        for (CertificateSource source : this.sources) {
            if (!source.isTrusted(certificateToken)) continue;
            return true;
        }
        return false;
    }

    public boolean isAllSelfSigned() {
        for (CertificateSource certificateSource : this.sources) {
            if (certificateSource.isAllSelfSigned()) continue;
            return false;
        }
        return true;
    }

    public Set<CertificateSourceType> getCertificateSource(CertificateToken certificateToken) {
        HashSet<CertificateSourceType> result = new HashSet<CertificateSourceType>();
        for (CertificateSource source : this.sources) {
            if (!source.isKnown(certificateToken)) continue;
            result.add(source.getCertificateSourceType());
        }
        return result;
    }

    public Set<CertificateToken> getByPublicKey(PublicKey publicKey) {
        HashSet<CertificateToken> result = new HashSet<CertificateToken>();
        for (CertificateSource source : this.sources) {
            result.addAll(source.getByPublicKey(publicKey));
        }
        return result;
    }

    public Set<CertificateToken> getBySki(byte[] ski) {
        HashSet<CertificateToken> result = new HashSet<CertificateToken>();
        for (CertificateSource source : this.sources) {
            result.addAll(source.getBySki(ski));
        }
        return result;
    }

    public Set<CertificateToken> getBySubject(X500PrincipalHelper subject) {
        HashSet<CertificateToken> result = new HashSet<CertificateToken>();
        for (CertificateSource source : this.sources) {
            result.addAll(source.getBySubject(subject));
        }
        return result;
    }

    public Set<CertificateToken> getByCertificateIdentifier(CertificateIdentifier certificateIdentifier) {
        HashSet<CertificateToken> result = new HashSet<CertificateToken>();
        for (CertificateSource source : this.sources) {
            result.addAll(source.getByCertificateIdentifier(certificateIdentifier));
        }
        return result;
    }

    public Set<CertificateToken> getByCertificateDigest(Digest digest) {
        HashSet<CertificateToken> result = new HashSet<CertificateToken>();
        for (CertificateSource source : this.sources) {
            result.addAll(source.getByCertificateDigest(digest));
        }
        return result;
    }

    public Set<CertificateToken> findTokensFromRefs(CertificateRef certificateRef) {
        HashSet<CertificateToken> result = new HashSet<CertificateToken>();
        for (CertificateSource source : this.sources) {
            result.addAll(source.findTokensFromCertRef(certificateRef));
        }
        return result;
    }

    public int getNumberOfSources() {
        return this.sources.size();
    }

    public int getNumberOfCertificates() {
        return this.getAllCertificateTokens().size();
    }

    public int getNumberOfEntities() {
        return this.getAllEntities().size();
    }
}

