/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.revocation;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.Revocation;
import eu.europa.esig.dss.spi.x509.revocation.OnlineRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RepositoryRevocationSource<R extends Revocation>
implements RevocationSource<R> {
    private static final Logger LOG = LoggerFactory.getLogger(RepositoryRevocationSource.class);
    private static final long serialVersionUID = 8116937707098957391L;
    protected OnlineRevocationSource<R> proxiedSource;
    private Long defaultNextUpdateDelay;
    private Long maxNextUpdateDelay;
    private boolean removeExpired = true;

    public abstract List<String> initRevocationTokenKey(CertificateToken var1);

    protected abstract RevocationToken<R> findRevocation(String var1, CertificateToken var2, CertificateToken var3);

    protected abstract void insertRevocation(RevocationToken<R> var1);

    protected abstract void updateRevocation(RevocationToken<R> var1);

    protected abstract void removeRevocation(RevocationToken<R> var1);

    public void setDefaultNextUpdateDelay(Long defaultNextUpdateDelay) {
        this.defaultNextUpdateDelay = defaultNextUpdateDelay == null ? null : Long.valueOf(defaultNextUpdateDelay * 1000L);
    }

    public void setMaxNextUpdateDelay(Long maxNextUpdateDelay) {
        this.maxNextUpdateDelay = maxNextUpdateDelay == null ? null : Long.valueOf(maxNextUpdateDelay * 1000L);
    }

    public void setProxySource(OnlineRevocationSource<R> proxiedSource) {
        this.proxiedSource = proxiedSource;
    }

    public void setRemoveExpired(boolean removeExpired) {
        this.removeExpired = removeExpired;
    }

    @Override
    public RevocationToken<R> getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        return this.getRevocationToken(certificateToken, issuerCertificateToken, false);
    }

    public RevocationToken<R> getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken, boolean forceRefresh) {
        if (certificateToken == null || issuerCertificateToken == null) {
            LOG.warn("Certificate token or issuer's certificate token is null. Cannot get a revocation token!");
            return null;
        }
        List<String> keys = this.initRevocationTokenKey(certificateToken);
        if (forceRefresh) {
            LOG.info("Cache is skipped to retrieve the revocation token for certificate '{}'", (Object)certificateToken.getDSSIdAsString());
        } else {
            RevocationToken<R> cachedRevocationToken = this.extractRevocationFromCacheSource(certificateToken, issuerCertificateToken, keys);
            if (cachedRevocationToken != null) {
                return cachedRevocationToken;
            }
        }
        return this.extractAndInsertRevocationTokenFromProxiedSource(certificateToken, issuerCertificateToken, keys);
    }

    private RevocationToken<R> extractRevocationFromCacheSource(CertificateToken certificateToken, CertificateToken issuerCertificateToken, List<String> keys) {
        Iterator<String> keyIterator = keys.iterator();
        while (keyIterator.hasNext()) {
            String key = keyIterator.next();
            RevocationToken<R> revocationToken = this.findRevocation(key, certificateToken, issuerCertificateToken);
            if (revocationToken != null) {
                if (this.isNotExpired(revocationToken, issuerCertificateToken)) {
                    LOG.info("Revocation token for certificate '{}' is loaded from the cache", (Object)certificateToken.getDSSIdAsString());
                    return revocationToken;
                }
                LOG.debug("Revocation token is expired");
                if (!this.removeExpired) continue;
                this.removeRevocation(revocationToken);
                keyIterator.remove();
                continue;
            }
            keyIterator.remove();
        }
        return null;
    }

    private RevocationToken<R> extractAndInsertRevocationTokenFromProxiedSource(CertificateToken certificateToken, CertificateToken issuerCertificateToken, List<String> keys) {
        if (this.proxiedSource == null) {
            LOG.warn("Proxied revocation source is not initialized for the called RevocationSource!");
            return null;
        }
        RevocationToken newToken = this.proxiedSource.getRevocationToken(certificateToken, issuerCertificateToken);
        if (newToken != null && newToken.isValid()) {
            if (!keys.contains(newToken.getRevocationTokenKey())) {
                LOG.info("Revocation token for certificate '{}' is added into the cache", (Object)certificateToken.getDSSIdAsString());
                this.insertRevocation(newToken);
            } else {
                LOG.info("Revocation token for certificate '{}' is updated in the cache", (Object)certificateToken.getDSSIdAsString());
                this.updateRevocation(newToken);
            }
        }
        return newToken;
    }

    private boolean isNotExpired(RevocationToken<R> revocationToken, CertificateToken certificateTokenIssuer) {
        Date validationDate = new Date();
        Date nextUpdate = revocationToken.getNextUpdate();
        if (nextUpdate == null) {
            CertificateToken certificateToken = revocationToken.getIssuerCertificateToken();
            if (certificateToken == null) {
                certificateToken = certificateTokenIssuer;
            }
            if (!certificateToken.isValidOn(validationDate)) {
                return false;
            }
        }
        Date thisUpdate = revocationToken.getThisUpdate();
        if (nextUpdate == null && this.defaultNextUpdateDelay != null && thisUpdate != null) {
            nextUpdate = new Date(thisUpdate.getTime() + this.defaultNextUpdateDelay);
        }
        if (nextUpdate != null) {
            Date maxNextUpdate;
            if (this.maxNextUpdateDelay != null && thisUpdate != null && nextUpdate.after(maxNextUpdate = new Date(thisUpdate.getTime() + this.maxNextUpdateDelay))) {
                nextUpdate = maxNextUpdate;
            }
            return nextUpdate.after(validationDate);
        }
        return false;
    }
}

