/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.revocation.crl;

import eu.europa.esig.dss.crl.CRLUtils;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.x509.revocation.crl.OfflineCRLSource;
import eu.europa.esig.dss.utils.Utils;
import java.io.InputStream;

public class ExternalResourcesCRLSource
extends OfflineCRLSource {
    private static final long serialVersionUID = -985602836642741439L;

    public ExternalResourcesCRLSource(String ... paths) {
        for (String pathItem : paths) {
            this.addCRLToken(this.getClass().getResourceAsStream(pathItem));
        }
    }

    public ExternalResourcesCRLSource(InputStream ... inputStreams) {
        for (InputStream inputStream : inputStreams) {
            this.addCRLToken(inputStream);
        }
    }

    private void addCRLToken(InputStream inputStream) {
        try (InputStream is = inputStream;){
            this.addBinary(CRLUtils.buildCRLBinary((byte[])Utils.toByteArray((InputStream)is)), RevocationOrigin.EXTERNAL);
        }
        catch (Exception e) {
            throw new DSSException("Unable to parse the stream (CRL is expected)", (Throwable)e);
        }
    }
}

