/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.revocation.ocsp;

import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.x509.revocation.OfflineRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPTokenRefMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OfflineOCSPSource
extends OfflineRevocationSource<OCSP> {
    private static final Logger LOG = LoggerFactory.getLogger(OfflineOCSPSource.class);

    protected OfflineOCSPSource() {
        super(new OCSPTokenRefMatcher());
    }

    @Override
    public List<RevocationToken<OCSP>> getRevocationTokens(CertificateToken certificate, CertificateToken issuer) {
        Objects.requireNonNull(certificate, "The certificate to be verified cannot be null");
        Objects.requireNonNull(issuer, "The issuer of the certificate to be verified cannot be null");
        ArrayList<RevocationToken<OCSP>> result = new ArrayList<RevocationToken<OCSP>>();
        Set collectedBinaries = this.getAllRevocationBinaries();
        LOG.trace("--> OfflineOCSPSource queried for {} contains: {} element(s).", (Object)certificate.getDSSIdAsString(), (Object)collectedBinaries.size());
        for (EncapsulatedRevocationTokenIdentifier binary : collectedBinaries) {
            OCSPResponseBinary ocspBinary = (OCSPResponseBinary)binary;
            BasicOCSPResp basicOCSPResp = ocspBinary.getBasicOCSPResp();
            SingleResp latestSingleResponse = DSSRevocationUtils.getLatestSingleResponse(basicOCSPResp, certificate, issuer);
            if (latestSingleResponse == null) continue;
            OCSPToken ocspToken = new OCSPToken(basicOCSPResp, latestSingleResponse, certificate, issuer);
            this.addRevocation(ocspToken, ocspBinary);
            result.add(ocspToken);
        }
        LOG.trace("--> OfflineOCSPSource found result(s) : {}", (Object)result.size());
        return result;
    }
}

