/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.client.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcCacheConnector {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcCacheConnector.class);
    private final DataSource dataSource;

    public JdbcCacheConnector(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(String query, Object ... arguments) {
        Objects.requireNonNull(query, "Query cannot be null!");
        Connection c = null;
        PreparedStatement s = null;
        try {
            int ii;
            c = this.dataSource.getConnection();
            s = c.prepareStatement(query);
            for (ii = 0; ii < arguments.length; ++ii) {
                s.setObject(ii + 1, arguments[ii]);
            }
            ii = s.executeUpdate();
            c.commit();
            LOG.debug("The query [{}] has been executed successfully", (Object)query);
            int n = ii;
            this.closeQuietly(c, s, null);
            return n;
        }
        catch (SQLException e) {
            try {
                LOG.error("Unable to execute the query [{}]. Reason : '{}'", new Object[]{query, e.getMessage(), e});
                this.rollback(c);
                int n = 0;
                this.closeQuietly(c, s, null);
                return n;
            }
            catch (Throwable throwable) {
                this.closeQuietly(c, s, null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<JdbcResultRecord> select(String selectQuery, Collection<JdbcResultRequest> requests, Object ... arguments) {
        Connection c = null;
        PreparedStatement s = null;
        ResultSet rs = null;
        try {
            c = this.dataSource.getConnection();
            s = c.prepareStatement(selectQuery);
            for (int ii = 0; ii < arguments.length; ++ii) {
                s.setObject(ii + 1, arguments[ii]);
            }
            rs = s.executeQuery();
            ArrayList<JdbcResultRecord> records = new ArrayList<JdbcResultRecord>();
            while (rs.next()) {
                JdbcResultRecord resultRecord = new JdbcResultRecord();
                for (JdbcResultRequest request : requests) {
                    Object object = rs.getObject(request.getColumnName(), request.getTargetClass());
                    resultRecord.put(request.getColumnName(), object);
                }
                records.add(resultRecord);
            }
            c.commit();
            LOG.debug("The SELECT query [{}] has been executed successfully.", (Object)selectQuery);
            ArrayList<JdbcResultRecord> arrayList = records;
            this.closeQuietly(c, s, rs);
            return arrayList;
        }
        catch (SQLException e) {
            try {
                LOG.error("Unable to execute query [{}]. Reason : {}", new Object[]{selectQuery, e.getMessage(), e});
                this.rollback(c);
                Set<JdbcResultRecord> set = Collections.emptySet();
                this.closeQuietly(c, s, rs);
                return set;
            }
            catch (Throwable throwable) {
                this.closeQuietly(c, s, rs);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableQuery(String query) {
        Connection c = null;
        Statement s = null;
        try {
            c = this.dataSource.getConnection();
            s = c.createStatement();
            boolean result = s.execute(query);
            c.commit();
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeQuietly(c, s, null);
        }
    }

    public int executeThrowable(String query) throws SQLException {
        Connection c = null;
        Statement s = null;
        try {
            c = this.dataSource.getConnection();
            s = c.createStatement();
            int result = s.executeUpdate(query);
            c.commit();
            int n = result;
            return n;
        }
        catch (SQLException e) {
            this.rollback(c);
            throw e;
        }
        finally {
            this.closeQuietly(c, s, null);
        }
    }

    protected void rollback(Connection c) {
        if (c != null) {
            try {
                LOG.warn("Transaction is being rolled back");
                c.rollback();
            }
            catch (SQLException e) {
                LOG.error("Unable to rollback", (Throwable)e);
            }
        }
    }

    protected void closeQuietly(Connection c, Statement s, ResultSet rs) {
        this.closeQuietly(rs);
        this.closeQuietly(s);
        this.closeQuietly(c);
    }

    private void closeQuietly(Connection c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void closeQuietly(Statement s) {
        try {
            if (s != null) {
                s.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void closeQuietly(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static class JdbcResultRequest {
        private final String columnName;
        private final Class targetClass;

        public JdbcResultRequest(String columnName, Class targetClass) {
            this.columnName = columnName;
            this.targetClass = targetClass;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public Class getTargetClass() {
            return this.targetClass;
        }
    }

    public static class JdbcResultRecord {
        private final Map<String, Object> row = new HashMap<String, Object>();

        public void put(String columnName, Object value) {
            this.row.put(columnName, value);
        }

        public Object get(String columnName) {
            return this.row.get(columnName);
        }
    }
}

