/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.aia;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.exception.DSSExternalResourceException;
import eu.europa.esig.dss.spi.x509.aia.AIASource;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeAIASource
implements AIASource {
    private static final long serialVersionUID = 948088043702414489L;
    private static final Logger LOG = LoggerFactory.getLogger(CompositeAIASource.class);
    private Map<String, AIASource> aIASource;

    public void setAIASources(Map<String, AIASource> aIASource) {
        this.aIASource = aIASource;
    }

    @Override
    public Set<CertificateToken> getCertificatesByAIA(CertificateToken certificateToken) {
        for (Map.Entry<String, AIASource> entry : this.aIASource.entrySet()) {
            String sourceKey = entry.getKey();
            AIASource source = entry.getValue();
            LOG.debug("Trying to get timestamp with AIASource '{}'", (Object)sourceKey);
            try {
                Set<CertificateToken> certificateTokens = source.getCertificatesByAIA(certificateToken);
                if (certificateTokens == null) continue;
                LOG.debug("Successfully retrieved certificateTokens with AiaSource Source '{}'", (Object)sourceKey);
                return certificateTokens;
            }
            catch (Exception e) {
                LOG.debug("Unable to retrieve the certificateTokens with AIA Source '{}' : {}", (Object)sourceKey, (Object)e.getMessage());
            }
        }
        throw new DSSExternalResourceException("Unable to retrieve the certificateTokens (" + this.aIASource.size() + " tries)");
    }
}

