/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.token.AbstractSignatureTokenConnection;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.token.KSPrivateKeyEntry;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public abstract class AbstractKeyStoreTokenConnection
extends AbstractSignatureTokenConnection {
    abstract KeyStore getKeyStore() throws DSSException;

    abstract KeyStore.ProtectionParameter getKeyProtectionParameter();

    public List<DSSPrivateKeyEntry> getKeys() throws DSSException {
        ArrayList<DSSPrivateKeyEntry> list = new ArrayList<DSSPrivateKeyEntry>();
        try {
            KeyStore keyStore = this.getKeyStore();
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                list.add((DSSPrivateKeyEntry)this.getKSPrivateKeyEntry(alias, this.getKeyProtectionParameter()));
            }
        }
        catch (GeneralSecurityException e) {
            throw new DSSException("Unable to retrieve keys from keystore", (Throwable)e);
        }
        return list;
    }

    public KSPrivateKeyEntry getKey(String alias) {
        return this.getKSPrivateKeyEntry(alias, this.getKeyProtectionParameter());
    }

    public KSPrivateKeyEntry getKey(String alias, String password) {
        return this.getKSPrivateKeyEntry(alias, this.createProtectionParameter(password));
    }

    private KSPrivateKeyEntry getKSPrivateKeyEntry(String alias, KeyStore.ProtectionParameter passwordProtection) {
        KeyStore keyStore = this.getKeyStore();
        try {
            if (keyStore.isKeyEntry(alias)) {
                KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(alias, passwordProtection);
                return new KSPrivateKeyEntry(alias, entry);
            }
        }
        catch (GeneralSecurityException e) {
            throw new DSSException("Unable to retrieve key for alias '" + alias + "'", (Throwable)e);
        }
        return null;
    }

    protected KeyStore.ProtectionParameter createProtectionParameter(String password) {
        KeyStore.PasswordProtection protection = password == null ? null : new KeyStore.PasswordProtection(password.toCharArray());
        return protection;
    }
}

