/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.token.AbstractKeyStoreTokenConnection;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import javax.security.auth.DestroyFailedException;

public class KeyStoreSignatureTokenConnection
extends AbstractKeyStoreTokenConnection {
    private final KeyStore keyStore;
    private final KeyStore.PasswordProtection password;

    public KeyStoreSignatureTokenConnection(byte[] ksBytes, String ksType, KeyStore.PasswordProtection ksPassword) {
        this(new ByteArrayInputStream(ksBytes), ksType, ksPassword);
    }

    public KeyStoreSignatureTokenConnection(String filepath, String ksType, KeyStore.PasswordProtection ksPassword) throws IOException {
        this(new File(filepath), ksType, ksPassword);
    }

    public KeyStoreSignatureTokenConnection(File ksFile, String ksType, KeyStore.PasswordProtection ksPassword) throws IOException {
        this(new FileInputStream(ksFile), ksType, ksPassword);
    }

    public KeyStoreSignatureTokenConnection(InputStream ksStream, String ksType, KeyStore.PasswordProtection password) {
        try (InputStream is = ksStream;){
            this.keyStore = KeyStore.getInstance(ksType);
            this.password = password;
            this.keyStore.load(is, password.getPassword());
        }
        catch (Exception e) {
            throw new DSSException("Unable to instantiate KeyStoreSignatureTokenConnection", (Throwable)e);
        }
    }

    @Override
    KeyStore getKeyStore() {
        return this.keyStore;
    }

    @Override
    KeyStore.PasswordProtection getKeyProtectionParameter() {
        return this.password;
    }

    @Override
    public void close() {
        if (this.password != null) {
            try {
                this.password.destroy();
            }
            catch (DestroyFailedException e) {
                LOG.error("Unable to destroy password", (Throwable)e);
            }
        }
    }
}

