/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.alerts.handlers.log;

import eu.europa.esig.dss.alert.handler.AlertHandler;
import eu.europa.esig.dss.spi.tsl.LOTLInfo;
import eu.europa.esig.dss.spi.tsl.PivotInfo;
import eu.europa.esig.dss.utils.Utils;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogLOTLLocationChangeAlertHandler
implements AlertHandler<LOTLInfo> {
    private static final Logger LOG = LoggerFactory.getLogger(LogLOTLLocationChangeAlertHandler.class);

    public void process(LOTLInfo currentInfo) {
        List pivotInfos = currentInfo.getPivotInfos();
        if (Utils.isCollectionNotEmpty((Collection)pivotInfos)) {
            for (PivotInfo pivotInfo : pivotInfos) {
                if (Utils.areStringsEqual((String)pivotInfo.getLOTLLocation(), (String)currentInfo.getUrl())) continue;
                LOG.warn("The LOTL Location has changed - new location : {}", (Object)pivotInfo.getLOTLLocation());
                break;
            }
        }
    }
}

