/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.function.converter;

import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.trustedlist.jaxb.tsl.InternationalNamesType;
import eu.europa.esig.trustedlist.jaxb.tsl.MultiLangNormStringType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;

public class InternationalNamesTypeConverter
implements Function<InternationalNamesType, Map<String, List<String>>> {
    private final Predicate<String> predicate;

    public InternationalNamesTypeConverter() {
        this(x -> true);
    }

    public InternationalNamesTypeConverter(Predicate<String> predicate) {
        this.predicate = predicate;
    }

    @Override
    public Map<String, List<String>> apply(InternationalNamesType original) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        if (original != null && Utils.isCollectionNotEmpty((Collection)original.getName())) {
            for (MultiLangNormStringType multiLangNormString : original.getName()) {
                String lang = multiLangNormString.getLang();
                String value = multiLangNormString.getValue();
                if (!this.predicate.test(value)) continue;
                result.computeIfAbsent(lang, k -> new ArrayList()).add(value);
            }
        }
        return result;
    }
}

