/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.function.converter;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.tsl.OtherTSLPointer;
import eu.europa.esig.dss.tsl.function.converter.DigitalIdentityListTypeConverter;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.trustedlist.jaxb.tsl.DigitalIdentityListType;
import eu.europa.esig.trustedlist.jaxb.tsl.OtherTSLPointerType;
import eu.europa.esig.trustedlist.jaxb.tsl.ServiceDigitalIdentityListType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public class OtherTSLPointerConverter
implements Function<OtherTSLPointerType, OtherTSLPointer> {
    @Override
    public OtherTSLPointer apply(OtherTSLPointerType original) {
        return new OtherTSLPointer(original.getTSLLocation(), Collections.unmodifiableList(this.getCertificates(original.getServiceDigitalIdentities())));
    }

    private List<CertificateToken> getCertificates(ServiceDigitalIdentityListType serviceDigitalIdentities) {
        ArrayList<CertificateToken> certificates = new ArrayList<CertificateToken>();
        if (serviceDigitalIdentities != null && Utils.isCollectionNotEmpty((Collection)serviceDigitalIdentities.getServiceDigitalIdentity())) {
            DigitalIdentityListTypeConverter converter = new DigitalIdentityListTypeConverter();
            for (DigitalIdentityListType digitalIdentityList : serviceDigitalIdentities.getServiceDigitalIdentity()) {
                certificates.addAll(converter.apply(digitalIdentityList));
            }
        }
        return certificates;
    }
}

