/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.cache.access;

import eu.europa.esig.dss.tsl.cache.CacheKey;
import eu.europa.esig.dss.tsl.cache.DownloadCache;
import eu.europa.esig.dss.tsl.cache.ParsingCache;
import eu.europa.esig.dss.tsl.cache.ValidationCache;
import eu.europa.esig.dss.tsl.cache.access.ReadOnlyCacheAccess;
import eu.europa.esig.dss.tsl.dto.DownloadCacheDTO;
import eu.europa.esig.dss.tsl.dto.ParsingCacheDTO;
import eu.europa.esig.dss.tsl.dto.ValidationCacheDTO;

public class ReadOnlyCacheAccessByKey {
    protected final CacheKey key;
    protected final DownloadCache downloadCache;
    protected final ParsingCache parsingCache;
    protected final ValidationCache validationCache;
    private final ReadOnlyCacheAccess readOnlyCacheAccess;

    public ReadOnlyCacheAccessByKey(CacheKey key, DownloadCache downloadCache, ParsingCache parsingCache, ValidationCache validationCache) {
        this.key = key;
        this.downloadCache = downloadCache;
        this.parsingCache = parsingCache;
        this.validationCache = validationCache;
        this.readOnlyCacheAccess = new ReadOnlyCacheAccess(downloadCache, parsingCache, validationCache);
    }

    public DownloadCacheDTO getDownloadReadOnlyResult() {
        return this.readOnlyCacheAccess.getDownloadCacheDTO(this.key);
    }

    public ParsingCacheDTO getParsingReadOnlyResult() {
        return this.readOnlyCacheAccess.getParsingCacheDTO(this.key);
    }

    public ValidationCacheDTO getValidationReadOnlyResult() {
        return this.readOnlyCacheAccess.getValidationCacheDTO(this.key);
    }
}

