/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.runnable;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.client.http.DSSFileLoader;
import eu.europa.esig.dss.tsl.cache.access.CacheAccessByKey;
import eu.europa.esig.dss.tsl.runnable.AbstractAnalysis;
import eu.europa.esig.dss.tsl.source.LOTLSource;
import java.util.concurrent.CountDownLatch;

public class LOTLAnalysis
extends AbstractAnalysis
implements Runnable {
    private final LOTLSource source;
    private final CountDownLatch latch;

    public LOTLAnalysis(LOTLSource source, CacheAccessByKey cacheAccess, DSSFileLoader dssFileLoader, CountDownLatch latch) {
        super(cacheAccess, dssFileLoader);
        this.source = source;
        this.latch = latch;
    }

    @Override
    public void run() {
        DSSDocument document = this.download(this.source.getUrl());
        if (document != null) {
            this.lotlParsing(document, this.source);
            this.validation(document, this.source.getCertificateSource());
        }
        this.latch.countDown();
    }
}

