/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.runnable;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.client.http.DSSFileLoader;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.tsl.cache.CacheKey;
import eu.europa.esig.dss.tsl.cache.access.CacheAccessByKey;
import eu.europa.esig.dss.tsl.cache.access.CacheAccessFactory;
import eu.europa.esig.dss.tsl.cache.access.ReadOnlyCacheAccess;
import eu.europa.esig.dss.tsl.dto.ParsingCacheDTO;
import eu.europa.esig.dss.tsl.dto.ValidationCacheDTO;
import eu.europa.esig.dss.tsl.runnable.AbstractAnalysis;
import eu.europa.esig.dss.tsl.runnable.PivotProcessing;
import eu.europa.esig.dss.tsl.runnable.PivotProcessingResult;
import eu.europa.esig.dss.tsl.source.LOTLSource;
import eu.europa.esig.dss.tsl.validation.TLValidatorTask;
import eu.europa.esig.dss.utils.Utils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LOTLWithPivotsAnalysis
extends AbstractAnalysis
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(LOTLWithPivotsAnalysis.class);
    private final CacheAccessFactory cacheAccessFactory;
    private final LOTLSource lotlSource;
    private final DSSFileLoader dssFileLoader;
    private final CountDownLatch latch;

    public LOTLWithPivotsAnalysis(CacheAccessFactory cacheAccessFactory, LOTLSource source, DSSFileLoader dssFileLoader, CountDownLatch latch) {
        super(cacheAccessFactory.getCacheAccess(source.getCacheKey()), dssFileLoader);
        this.cacheAccessFactory = cacheAccessFactory;
        this.lotlSource = source;
        this.dssFileLoader = dssFileLoader;
        this.latch = latch;
    }

    @Override
    public void run() {
        DSSDocument document = this.download(this.lotlSource.getUrl());
        if (document != null) {
            this.lotlParsing(document, this.lotlSource);
            this.validation(document, this.getCurrentCertificateSource());
        }
        this.latch.countDown();
    }

    private CertificateSource getCurrentCertificateSource() {
        CertificateSource initialCertificateSource = this.lotlSource.getCertificateSource();
        CertificateSource currentCertificateSource = null;
        ParsingCacheDTO currentLOTLParsing = this.getCacheAccessByKey().getParsingReadOnlyResult();
        if (currentLOTLParsing != null) {
            List<String> pivotURLs = currentLOTLParsing.getPivotUrls();
            if (Utils.isCollectionEmpty(pivotURLs)) {
                LOG.trace("No pivot LOTL found");
                currentCertificateSource = initialCertificateSource;
            } else {
                currentCertificateSource = this.getCurrentCertificateSourceFromPivots(initialCertificateSource, pivotURLs);
            }
        } else {
            LOG.warn("Unable to retrieve the parsing result for the current LOTL (allowed signing certificates set from the configuration)");
            currentCertificateSource = initialCertificateSource;
        }
        return currentCertificateSource;
    }

    private CertificateSource getCurrentCertificateSourceFromPivots(CertificateSource initialCertificateSource, List<String> pivotURLs) {
        Map<String, PivotProcessingResult> processingResults = this.downloadAndParseAllPivots(pivotURLs);
        ReadOnlyCacheAccess readOnlyCacheAccess = this.cacheAccessFactory.getReadOnlyCacheAccess();
        List pivotUrlsReversed = Utils.reverseList(pivotURLs);
        CertificateSource currentCertificateSource = initialCertificateSource;
        for (String pivotUrl : pivotUrlsReversed) {
            CacheKey cacheKey = new CacheKey(pivotUrl);
            PivotProcessingResult pivotProcessingResult = processingResults.get(pivotUrl);
            if (pivotProcessingResult != null) {
                CacheAccessByKey pivotCacheAccess = this.cacheAccessFactory.getCacheAccess(cacheKey);
                this.validationPivot(pivotCacheAccess, pivotProcessingResult.getPivot(), currentCertificateSource);
                ValidationCacheDTO validationResult = readOnlyCacheAccess.getValidationCacheDTO(cacheKey);
                if (validationResult != null) {
                    if (validationResult.isValid()) {
                        currentCertificateSource = pivotProcessingResult.getCertificateSource();
                        continue;
                    }
                    LOG.warn("Pivot LOTL '{}' is not valid ({}/{})", new Object[]{pivotUrl, validationResult.getIndication(), validationResult.getSubIndication()});
                    continue;
                }
                LOG.warn("No validation result found for Pivot LOTL '{}'", (Object)pivotUrl);
                continue;
            }
            LOG.warn("No processing result for Pivot LOTL '{}'", (Object)pivotUrl);
        }
        return currentCertificateSource;
    }

    private void validationPivot(CacheAccessByKey pivotCacheAccess, DSSDocument document, CertificateSource certificateSource) {
        if (pivotCacheAccess.isValidationRefreshNeeded()) {
            try {
                LOG.debug("Validating the Pivot LOTL with cache key '{}'...", (Object)pivotCacheAccess.getCacheKey().getKey());
                TLValidatorTask validationTask = new TLValidatorTask(document, certificateSource);
                pivotCacheAccess.update(validationTask.get());
            }
            catch (Exception e) {
                LOG.error("Cannot validate the Pivot LOTL with the cache key '{}' : {}", (Object)pivotCacheAccess.getCacheKey().getKey(), (Object)e.getMessage());
                pivotCacheAccess.validationError(e);
            }
        }
    }

    private Map<String, PivotProcessingResult> downloadAndParseAllPivots(List<String> pivotURLs) {
        ExecutorService executorService = Executors.newFixedThreadPool(pivotURLs.size());
        HashMap<String, Future<PivotProcessingResult>> futures = new HashMap<String, Future<PivotProcessingResult>>();
        for (String pivotUrl : pivotURLs) {
            CacheAccessByKey pivotCacheAccess = this.cacheAccessFactory.getCacheAccess(new CacheKey(pivotUrl));
            LOTLSource pivotSource = new LOTLSource();
            pivotSource.setUrl(pivotUrl);
            pivotSource.setLotlPredicate(this.lotlSource.getLotlPredicate());
            pivotSource.setTlPredicate(this.lotlSource.getTlPredicate());
            pivotSource.setPivotSupport(this.lotlSource.isPivotSupport());
            futures.put(pivotUrl, executorService.submit(new PivotProcessing(pivotSource, pivotCacheAccess, this.dssFileLoader)));
        }
        HashMap<String, PivotProcessingResult> processingResults = new HashMap<String, PivotProcessingResult>();
        for (Map.Entry entry : futures.entrySet()) {
            try {
                processingResults.put((String)entry.getKey(), (PivotProcessingResult)((Future)entry.getValue()).get());
            }
            catch (InterruptedException e) {
                LOG.error(String.format("Unable to retrieve the PivotProcessingResult for url '%s'", entry.getKey()), (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                LOG.error(String.format("Unable to retrieve the PivotProcessingResult for url '%s'", entry.getKey()), (Throwable)e);
            }
        }
        this.shutdownAndAwaitTermination(executorService);
        return processingResults;
    }

    private void shutdownAndAwaitTermination(ExecutorService executorService) {
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.shutdownNowAndAwaitTermination(executorService);
            }
        }
        catch (InterruptedException e) {
            this.shutdownNowAndAwaitTermination(executorService);
            Thread.currentThread().interrupt();
        }
    }

    private void shutdownNowAndAwaitTermination(ExecutorService executorService) {
        executorService.shutdownNow();
        try {
            if (!executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                LOG.warn("More than 10s to terminate the service executor");
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Unable to interrupt the service executor", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }
}

