/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.validation;

import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.enumerations.TokenExtractionStrategy;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.ValidationPolicyFacade;
import eu.europa.esig.dss.simplereport.SimpleReport;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.CommonTrustedCertificateSource;
import eu.europa.esig.dss.tsl.validation.ValidationResult;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.CommonCertificateVerifier;
import eu.europa.esig.dss.validation.executor.ValidationLevel;
import eu.europa.esig.dss.validation.reports.Reports;
import eu.europa.esig.dss.xades.definition.xades132.XAdES132Paths;
import eu.europa.esig.dss.xades.validation.XMLDocumentValidator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public class TLValidatorTask
implements Supplier<ValidationResult> {
    private final DSSDocument trustedList;
    private final CertificateSource certificateSource;

    public TLValidatorTask(DSSDocument trustedList, CertificateSource certificateSource) {
        Objects.requireNonNull(trustedList, "The document is null");
        Objects.requireNonNull(certificateSource, "The certificate source is null");
        this.trustedList = trustedList;
        this.certificateSource = certificateSource;
    }

    @Override
    public ValidationResult get() {
        Reports reports = this.validateTL();
        return this.fillResult(reports);
    }

    private Reports validateTL() {
        CommonCertificateVerifier certificateVerifier = new CommonCertificateVerifier(true);
        certificateVerifier.setTrustedCertSources(new CertificateSource[]{this.buildTrustedCertificateSource(this.certificateSource)});
        XMLDocumentValidator xmlDocumentValidator = new XMLDocumentValidator(this.trustedList);
        xmlDocumentValidator.setCertificateVerifier((CertificateVerifier)certificateVerifier);
        xmlDocumentValidator.setTokenExtractionStrategy(TokenExtractionStrategy.EXTRACT_CERTIFICATES_ONLY);
        xmlDocumentValidator.setEnableEtsiValidationReport(false);
        xmlDocumentValidator.setValidationLevel(ValidationLevel.BASIC_SIGNATURES);
        xmlDocumentValidator.setSkipValidationContextExecution(true);
        List xadesPathsHolders = xmlDocumentValidator.getXAdESPathsHolder();
        xadesPathsHolders.clear();
        xadesPathsHolders.add(new XAdES132Paths());
        return xmlDocumentValidator.validateDocument(this.getTrustedListValidationPolicy());
    }

    private ValidationResult fillResult(Reports reports) {
        SimpleReport simpleReport = reports.getSimpleReport();
        if (simpleReport.getSignaturesCount() != 1) {
            throw new DSSException(String.format("Number of signatures must be equal to 1 (currently : %s)", simpleReport.getSignaturesCount()));
        }
        Indication indication = simpleReport.getIndication(simpleReport.getFirstSignatureId());
        SubIndication subIndication = simpleReport.getSubIndication(simpleReport.getFirstSignatureId());
        DiagnosticData diagnosticData = reports.getDiagnosticData();
        SignatureWrapper signatureWrapper = diagnosticData.getSignatureById(diagnosticData.getFirstSignatureId());
        Date signingTime = signatureWrapper.getClaimedSigningTime();
        CertificateWrapper signingCertificateWrapper = signatureWrapper.getSigningCertificate();
        CertificateToken signingCertificate = null;
        if (signingCertificateWrapper != null) {
            signingCertificate = DSSUtils.loadCertificate((byte[])signingCertificateWrapper.getBinaries());
        }
        return new ValidationResult(indication, subIndication, signingTime, signingCertificate, this.certificateSource);
    }

    private CommonTrustedCertificateSource buildTrustedCertificateSource(CertificateSource certificateSource) {
        CommonTrustedCertificateSource commonTrustedCertificateSource = new CommonTrustedCertificateSource();
        commonTrustedCertificateSource.importAsTrusted(certificateSource);
        return commonTrustedCertificateSource;
    }

    private ValidationPolicy getTrustedListValidationPolicy() {
        try {
            return ValidationPolicyFacade.newFacade().getTrustedListValidationPolicy();
        }
        catch (Exception e) {
            throw new DSSException("Unable to load the validation policy for trusted list", (Throwable)e);
        }
    }
}

