/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.function.converter;

import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.trustedlist.jaxb.tsl.NonEmptyMultiLangURIListType;
import eu.europa.esig.trustedlist.jaxb.tsl.NonEmptyMultiLangURIType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;

public class NonEmptyMultiLangURIListTypeConverter
implements Function<NonEmptyMultiLangURIListType, Map<String, List<String>>> {
    private final Predicate<String> predicate;

    public NonEmptyMultiLangURIListTypeConverter() {
        this(x -> true);
    }

    public NonEmptyMultiLangURIListTypeConverter(Predicate<String> predicate) {
        this.predicate = predicate;
    }

    @Override
    public Map<String, List<String>> apply(NonEmptyMultiLangURIListType original) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        if (original != null && Utils.isCollectionNotEmpty((Collection)original.getURI())) {
            for (NonEmptyMultiLangURIType multiLangURIString : original.getURI()) {
                String lang = multiLangURIString.getLang();
                String value = multiLangURIString.getValue();
                if (!this.predicate.test(value)) continue;
                result.computeIfAbsent(lang, k -> new ArrayList()).add(value);
            }
        }
        return result;
    }
}

