/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.utils.impl;

import com.google.common.base.Ascii;
import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import eu.europa.esig.dss.utils.IUtils;
import eu.europa.esig.dss.utils.impl.FilterByExtensions;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;

public class GoogleGuavaUtils
implements IUtils {
    private static final String STRING_EMPTY = "";

    public boolean isStringEmpty(String text) {
        return Strings.isNullOrEmpty((String)text);
    }

    public boolean isStringNotEmpty(String text) {
        return !Strings.isNullOrEmpty((String)text);
    }

    public boolean isStringBlank(String text) {
        return Strings.isNullOrEmpty((String)text) || CharMatcher.whitespace().matchesAllOf((CharSequence)text);
    }

    public boolean isStringNotBlank(String text) {
        return !this.isStringBlank(text);
    }

    public boolean areStringsEqual(String text1, String text2) {
        if (text1 == null && text2 == null) {
            return true;
        }
        if (text1 == null || text2 == null) {
            return false;
        }
        return text1.equals(text2);
    }

    public boolean areStringsEqualIgnoreCase(String text1, String text2) {
        if (text1 == null && text2 == null) {
            return true;
        }
        if (text1 == null || text2 == null) {
            return false;
        }
        return text1.equalsIgnoreCase(text2);
    }

    public boolean isStringDigits(String text) {
        return !Strings.isNullOrEmpty((String)text) && CharMatcher.digit().matchesAllOf((CharSequence)text);
    }

    public String trim(String text) {
        if (Strings.isNullOrEmpty((String)text)) {
            return text;
        }
        return text.trim();
    }

    public String joinStrings(Collection<String> strings, String separator) {
        if (strings == null) {
            return null;
        }
        if (Strings.isNullOrEmpty((String)separator)) {
            separator = STRING_EMPTY;
        }
        Joiner joiner = Joiner.on((String)separator);
        return joiner.join(strings);
    }

    public String substringAfter(String text, String after) {
        if (Strings.isNullOrEmpty((String)text)) {
            return text;
        }
        if (after == null) {
            return STRING_EMPTY;
        }
        int indexOf = text.indexOf(after);
        if (indexOf == -1) {
            return STRING_EMPTY;
        }
        return text.substring(indexOf + after.length());
    }

    public boolean endsWithIgnoreCase(String text, String expected) {
        if (Strings.isNullOrEmpty((String)text) || Strings.isNullOrEmpty((String)expected)) {
            return false;
        }
        return this.lowerCase(text).endsWith(this.lowerCase(expected));
    }

    public String lowerCase(String text) {
        if (Strings.isNullOrEmpty((String)text)) {
            return text;
        }
        return text.toLowerCase();
    }

    public String upperCase(String text) {
        if (Strings.isNullOrEmpty((String)text)) {
            return text;
        }
        return text.toUpperCase();
    }

    public boolean isArrayEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public boolean isArrayNotEmpty(Object[] array) {
        return !this.isArrayEmpty(array);
    }

    public boolean isArrayEmpty(byte[] array) {
        return array == null || array.length == 0;
    }

    public boolean isArrayNotEmpty(byte[] array) {
        return !this.isArrayEmpty(array);
    }

    public byte[] subarray(byte[] array, int start, int length) {
        if (array == null) {
            return null;
        }
        return Arrays.copyOfRange(array, start, length);
    }

    public boolean isTrue(Boolean bool) {
        return bool != null && bool != false;
    }

    public boolean isCollectionEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public boolean isCollectionNotEmpty(Collection collection) {
        return collection != null && !collection.isEmpty();
    }

    public int collectionSize(Collection collection) {
        if (collection == null) {
            return 0;
        }
        return collection.size();
    }

    public String toHex(byte[] bytes) {
        return BaseEncoding.base16().encode(bytes).toLowerCase();
    }

    public byte[] fromHex(String hex) {
        return BaseEncoding.base16().lowerCase().decode((CharSequence)Ascii.toLowerCase((String)hex));
    }

    public String toBase64(byte[] bytes) {
        return BaseEncoding.base64().encode(bytes);
    }

    public byte[] fromBase64(String base64) {
        return BaseEncoding.base64().decode((CharSequence)CharMatcher.whitespace().removeFrom((CharSequence)base64));
    }

    public byte[] toByteArray(InputStream is) throws IOException {
        return ByteStreams.toByteArray((InputStream)is);
    }

    public void closeQuietly(Closeable closeable) {
        try {
            Closeables.close((Closeable)closeable, (boolean)true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void copy(InputStream is, OutputStream os) throws IOException {
        ByteStreams.copy((InputStream)is, (OutputStream)os);
    }

    public void write(byte[] content, OutputStream os) throws IOException {
        ByteStreams.copy((InputStream)new ByteArrayInputStream(content), (OutputStream)os);
    }

    public void cleanDirectory(File directory) throws IOException {
        if (directory == null || !directory.exists()) {
            throw new IllegalArgumentException("Not exists");
        }
        if (directory.isDirectory()) {
            File[] listFiles = directory.listFiles();
            if (listFiles == null) {
                return;
            }
            for (File file : listFiles) {
                if (file.isDirectory()) {
                    this.cleanDirectory(file);
                    continue;
                }
                if (!file.isFile()) continue;
                file.delete();
            }
        }
    }

    public Collection<File> listFiles(File folder, String[] extensions, boolean recursive) {
        return Files.fileTreeTraverser().preOrderTraversal((Object)folder).filter((Predicate)new FilterByExtensions(extensions)).toList();
    }
}

